#include <assert.h> // assert
#include <math.h>   // q, ceil
#include <stdio.h>  // printf
#include <stdlib.h> // malloc
#include <string.h>

#include "ec.h"
#include "murmurhash2.h"

#define min(a, b) (((a) < (b)) ? (a) : (b))
#define max(a, b) (((a) < (b)) ? (b) : (a))

#define BIT64 64
#define ECS_HASH(item, itemlen, i) MurmurHash2(item, itemlen, i)


#define BUCKET_TYPE_NUM 12
#define CONFIG_LENGTH 8
const uint8_t xy2flag_table[3][8]={
	{0},
	{1,2,3},
	{4,5,6,7,8,9,10,11}
};
const uint8_t flag2xy_table[3][8]={
	{0},
	{1,2,3},
	{4,5,6,7,8,9,10,11}
};
const uint8_t maxYforX[6]={0,0,0,8,3,1};
#define xy2flag(x,y) xy2flag_table[5-(x)][(y)]
const uint8_t BUCKET_ITEM_SIZE[BUCKET_TYPE_NUM][CONFIG_LENGTH] = {
	{0, 5, 2, 3, 4, 5, 6},
	{0, 4, 3, 4, 5, 16, 0},
	{1, 4, 4, 5, 6, 13, 0},
	{2, 4, 5, 6, 7, 10, 0},
	{0, 3, 4, 5, 27, 0, 0},
	{1, 3, 5, 6, 25, 0, 0},
	{2, 3, 6, 7, 23, 0, 0},
	{3, 3, 7, 8, 21, 0, 0},
	{4, 3, 8, 9, 19, 0, 0},
	{5, 3, 9, 10, 17, 0, 0},
	{6, 3, 10, 11, 15, 0, 0},
	{7, 3, 11, 12, 13, 0, 0}
};



void moveforward(bucket_t* b){
		int maxnum=BUCKET_ITEM_SIZE[b->flag][1];
		for (int i=1;i<maxnum-1;i++){
			b->fingerprint[i-1]=b->fingerprint[i];
			b->C[i-1]=b->C[i];
		}
		b->C[maxnum-1]=0;
		b->fingerprint[maxnum-1]=0;
	}

ECSketch *NewECSketch(size_t width, size_t depth) {
    assert(width > 0);
    assert(width < MAX_MEM);
    assert(depth > 0);

    ECSketch *ec = ECS_CALLOC(1, sizeof(ECSketch));

    ec->width = width;
    ec->depth = depth;

    return ec;
}

void ECS_Destroy(ECSketch *ec) {
    assert(ec);

    for (size_t i=0; i<ec->depth; i++){
		//for (size_t j=0; j<MAX_MEM+10; j++){
		for (size_t j=0; j<ec->depth; j++){
			ECS_FREE(&(ec->HK_EC[i][j]));
		}
    	ECS_FREE(ec->HK_EC[i]);
    }

    ECS_FREE(ec);
}


size_t EC_overflow(bucket_t* b, int j) {	//EC_overflow oecur in entry_j in the bucket
		int X=BUCKET_ITEM_SIZE[b->flag][1];
		int Y=BUCKET_ITEM_SIZE[b->flag][0];
		//stay_EC_overflow
		for(int i=j+1;i<X;i++){
			if(b->C[i]<b->C[j]){
				//entryswap(b,i,j);
				int t=b->C[j];
				b->C[j]=b->C[i];;
				b->C[i] = t;

				t=b->fingerprint[i];
				b->fingerprint[i] = b->fingerprint[j];
				b->fingerprint[j] = t;
				return 1;
			}
		}
		if(Y==maxYforX[X]){
			if(j==X-1){
				moveforward(b);
				b->flag=xy2flag(X-1,Y);
			}
			else if(j!=0){
			}
		}
		else{
			if(j==X){
				moveforward(b);
				b->flag=xy2flag(X-1,Y);
			}
			else{
				if(b->C[X-1]<=(1<<(BUCKET_ITEM_SIZE[xy2flag(X,Y+1)][BUCKET_ITEM_SIZE[xy2flag(X,Y+1)][1]+1]))){
					b->flag=xy2flag(X,Y+1);
				}
			}

		}
		return 1;
	}

size_t EC_plus(bucket_t* b, int j) {		//try to EC_plus entry_j in the bucket
										//return true if no EC_overflow happens
		b->C[j]++;
		if (b->C[j]>(1<<BUCKET_ITEM_SIZE[b->flag][2+j])){
			size_t res = EC_overflow(b, j);	//solve the EC_overflow
			if (!res) return 0;		//return false when we can't solve
		}
		return 1;
	}

size_t ECS_IncrBy(ECSketch *ec, const char *item, size_t itemlen, size_t value) {
    assert(ec);
    assert(item);

	uint32_t maxv = 0;
	uint32_t H1 = ECS_HASH(item, strlen(item), 0); 
	uint32_t FP = (H1 >> 24);
	
	//unsigned long long H2 = H1^Hash(std::to_string(FP));//XOR CUCKOO HASHING
	uint32_t H2 = H1^FP;
	uint32_t Hsh1 = H1 % ec->width;
	uint32_t Hsh2 = H2 % ec->width;
	uint32_t count = 0;
		
	uint32_t hash[2] = { Hsh1, Hsh2 };
	uint32_t hashHH[2] = { H1, H2 };
		
	size_t flag=0;
	size_t ii, jj;
	for(size_t i = 0; i < EC_d; i++){
		uint32_t f=ec->HK_EC[i][hash[i]].flag;
		for (size_t j = 0; j < BUCKET_ITEM_SIZE[f][1]; j++)
		{		
			if (ec->HK_EC[i][hash[i]].fingerprint[j] == FP) {
				//ec->HK_EC[i][hash[i]][j].C += value;
				EC_plus(&(ec->HK_EC[i][hash[i]]), j);
				maxv = max(maxv, ec->HK_EC[i][hash[i]].C[j]);
				return maxv;
			}
			if(!flag && ec->HK_EC[i][hash[i]].fingerprint[j] == 0)
			{
				ii=i; jj=j; flag=1;
			}
		}
	}
	if (flag) {
	    ec->HK_EC[ii][hash[ii]].fingerprint[jj] = FP;
	    ec->HK_EC[ii][hash[ii]].C[jj] = value;
	    return value;
	}
	//mean can not insert normally
	size_t rad = Hsh1 & 0x1;
	ec->HK_EC[rad][hash[rad]].fingerprint[0] = FP;
	ec->HK_EC[rad][hash[rad]].C[0] = value;
	maxv=max(maxv, value);
	return maxv;
}

size_t ECS_Query(ECSketch *ec, const char *item, size_t itemlen) {
    assert(ec);
    assert(item);
	
	int maxv = 0;
	uint32_t H1 = ECS_HASH(item, strlen(item), 0); 
	uint32_t FP = (H1 >> 24);
	//unsigned long long H2 = H1^Hash(std::to_string(FP));//XOR CUCKOO HASHING
	uint32_t H2 = H1^FP;
	uint32_t Hsh1 = H1 % ec->width;
	uint32_t Hsh2 = H2 % ec->width;
		
	uint32_t hash[2] = { Hsh1, Hsh2 };
	uint32_t hashHH[2] = { H1, H2 };

	size_t minv = (size_t)-1;
	for(size_t i = 0; i < EC_d; i++){
		int f=ec->HK_EC[i][hash[i]].flag;
		for (size_t j = 0; j < BUCKET_ITEM_SIZE[f][1]; j++)
		{		
			if (ec->HK_EC[i][hash[i]].fingerprint[j] == FP) {
				return ec->HK_EC[i][hash[i]].C[j];
			}
			minv = min(minv, ec->HK_EC[i][hash[i]].C[j]);
		}
	}
	return minv;
}


/************ used for debugging *******************
void CMS_Print(const CMSketch *cms) {
    assert(cms);

    for (int i = 0; i < cms->depth; ++i) {
        for (int j = 0; j < cms->width; ++j) {
            printf("%d\t", cms->array[(i * cms->width) + j]);
        }
        printf("\n");
    }
    printf("\tCounter is %lu\n", cms->counter);
} */
