# A Uniffed Framework for Dynamic Bit-level Counter Allocation in Sketches
This repository contains all the related code of our paper "A Uniffed Framework for Dynamic Bit-level Counter Allocation in Sketches".

## Introduction
Sketches are widely used for large-scale stream processing, but fixed-size counters (e.g., in Elastic Sketch) waste memory due to skewed data. BitMatcher solves this with dynamic resizing​ and cuckoo hashing, which maximizes memory usage while maintaining high throughput.

## About this repository
We implement our Bitmatcher in C++ and compare our results with CM sketch, A sketch, PCU sketch, EL sketch, nitro sketch, SALSA sketch, and others dynamic resizing methods like DHS sketch and switch sketch.

### Folders
We implemented the methods separately in Bitmatcher and new_Bitmatcher, the former contains the code of experiments from our previous conference paper "BitMatcher: Bit-level Counter Adjustment for Sketches", including accuracy comparisons with other sketch solutions on tasks like frequency estimation, heavy hitter detection, and heavy changer detection. The latter consists of newly added experiments for this work, covering parameter tuning and framework integration tests. Besides, the FPGA source code and detailed implementation plan of BitMatcher can be found in a separate FPGA folder.