#ifndef _Basesketch_H
#define _Basesketch_H
/*Implement  basic sketches based on Elastic Sketch, Waving Sketch, and RAP Sketch 
to test the effect of different dynamic counter allocation methods in different sketches.*/
#include <cmath>
#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <algorithm>
#include <string>
#include <cstring>
#include "BOBHash.h"
#include "params.h"
#include "UseSketch.h"
#define BN 4
using namespace std;
class Basesketch
{
private:
	struct heavy { unsigned int FP,value;};
	heavy** HK;
	BOBHash * bobhash;
	BOBHash * bobhash1;
	int M1;
	UseSketch* test;
	unsigned int len_bitmask=((1UL << 32) - 1);

public:
	Basesketch(int memory,int sketch,int key_len) :M1(M1){
		int bucket_num;
		len_bitmask=((1UL << key_len) - 1);
		switch(sketch){
			case 1:{
				M1=int(memory/((33+key_len)*BN+32));
				int m2=int(memory*0.75/8);
				cout<<"BaseSketch_Elastic: table num "<<1<<"bucket num"<<M1<<"light part"<<m2<<"cell num"<<BN<<endl;
				test=new Elastic(1,M1,BN,m2);
				break;
			}
			case 2:{
				M1=int(memory/((34+key_len)*BN+32));
				cout<<"BaseSketch_Waving: table num "<<1<<"bucket num"<<M1<<" cell num"<<BN<<endl;
				test=new Waving(1,M1,BN);
				break;
			}
			case 3:{
				M1=int(memory/((32+key_len)*BN));
				cout<<"BaseSketch_RAP: table num "<<1<<"bucket num"<<M1<<" cell num"<<BN<<endl;
				test=new RAP();
				break;
			}
			//default:{
			//	int bucket_len=64;
			//	bucket_num=memory/bucket_len/2;//two tables
			//}
		}
		HK= new heavy*[M1];
		for(int i=0;i<M1;i++){
			HK[i]=new heavy[BN];
		}
		bobhash = new BOBHash(1000);
		bobhash1 = new BOBHash(1035);
		clear();
    }

	//clear interface
	void clear()
	{
		for (int i = 0; i < M1; i++)
			for (int j = 0; j < BN; j++)
				HK[i][j].FP = HK[i][j].value=0;
	}

	// insert interface
	void Insert(const char *str){
		unsigned int FP = bobhash->run(str, KEY_LEN)&len_bitmask;
		unsigned int H1 = bobhash1->run(str, KEY_LEN) % M1;
		unsigned int min_size = INT32_MAX;
		int min_pos = -1;
		int flag = 0;
		for (int i = 0; i < BN; i++) {
			if (HK[H1][i].FP == FP) {
				test->insert(0,H1,i,true,FP);
				HK[H1][i].value++;
				flag = 1;
				break;
			}
			else if (HK[H1][i].value == 0) {
				test->insert(0,H1,i,false,FP );
				HK[H1][i].value = 1;
				HK[H1][i].FP = FP;
				flag = 1;
				break;
			}
			if (min_size > HK[H1][i].value) {
				min_pos = i;
				min_size = HK[H1][i].value;
			}
		}
		if (!flag) {
			int newnum=test->conflict(0,H1,min_pos,min_size,1,FP,HK[H1][min_pos].FP);
			if(newnum!=0){
				HK[H1][min_pos].FP = FP;
				HK[H1][min_pos].value = newnum;
			}	
		}
		return;		
	}

	// query interface
	double Query(const char * str)
	{
		unsigned int maxv = 0;
		unsigned int FP = bobhash->run(str, KEY_LEN)&len_bitmask;
		unsigned int H1 = bobhash1->run(str, KEY_LEN) % M1;
		for (int i = 0; i < BN; i++) {
			maxv=0;
			if (HK[H1][i].FP == FP) {
				maxv = HK[H1][i].value;
				int addnum=test->query(0,H1,i,FP);
				break;
			}
		}
		if (maxv == 0) {
			int addnum=test->query(-1,-1,-1,FP);
		}
		return maxv;
	}
	~Basesketch()
	{
		for (int i=0; i<MAX_MEM+10; i++){
			delete []HK[i];
		}
	}
};
#endif
