# BitMatcher 
## How to run

Suppose you've already cloned the repository.

You just need:

```
$ make 
$ ./bitmatcher -d dataset -o outputf_ile -m memory -b bucket_len -t 4 -e entry_num -f key_len -l level -p state_num -u method -a task -h HH_threshold
```
We provide a wide range of parameters to allow for the adjustment of various configurations of the experiment, they are as follows:

* -d the path to the dataset
* -o the path to output file (.txt), the result will be output in the terminal if it is "None".
* -m memory usage of experiment
* -b the length of each bucket in BM
* -t bitnum of flag use
* -e the number of entries of a bucket when initializing the table
* -f length of fingerprint of BM
* -l the level of table (only support 1 and 2)  
* -p the maximum number of transferable states of BM
* -u which type of sketch was the experiment based on? (1 is EL sketch, 2 is Waving sketch, and 3 is RAP sketch).
* -a task [hh, frequency, entropy, distribution]
* -h the threshold of the hh flow, which is only effective when -a is "hh"

Besides, you can also repeat the param tuning experiments and mix estimation experiments of Bitmatcher by running script files in this folder, their functions are as follows:

### Parameters Tuning

* param_hh.sh​​: Adjusts the Heavy Hitter (HH) threshold and bucket length to observe the impact of different bucket sizes on HH detection accuracy.
* param_key.sh​​: Adjusts the key length and evaluates its effect on different tasks.
* ​​param_state.sh​​: Adjusts the maximum state count and observes its influence on various tasks.

### Mix Estimation
* caida_exp.sh​​: Evaluates different dynamic counter allocation methods combined with various sketch frameworks on the CAIDA dataset.
* IMC_exp.sh​​: Evaluates different dynamic counter allocation methods combined with various sketch frameworks on the IMC dataset.
* ​skewness_exp.sh​​: Evaluates different dynamic counter allocation methods combined with various sketch frameworks on datasets with varying skewness levels.


## Output format
Metrics for ​​DHS, SW, and BM​ when integrated with different sketch frameworks. For detailed metrics, refer to the code and original experiments.


