#ifndef _UseSketch_H
#define _UseSketch_H

#include <stdint.h>
#include <string>
#include<string.h>
#include"iostream"
#include"params.h"
#include <cstdlib>
#include "BOBHash.h"
class UseSketch {
public:
    virtual void insert(int table_id, int bucket_id, int cell_id, bool havekey, unsigned int newkey) = 0;
    virtual int conflict(int table_id, int bucket_id, int cell_id, int num, bool havekey, unsigned int newkey,unsigned int oldkey) = 0;
    virtual void change(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did) = 0;
    virtual void write(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did) = 0;
	virtual void write_temp(int table_sid, int bucket_sid, int cell_sid,int pos)=0;
	virtual void reslove_temp(int table_did,int bucket_did)=0;
	virtual void kickout(int table_id, int bucket_id, int cell_id,int num,unsigned int newkey,unsigned int oldkey,bool realkick)=0;
	virtual int query(int table_sid, int bucket_sid, int cell_sid,unsigned int key)=0;
    virtual void clear() {}
    virtual ~UseSketch() {}
};
//Implement the interfaces for various sketches respectively
class Elastic : public UseSketch{
private:
int table,bucket,cell;
uint32_t **nvote;
bool*** flag;
bool* temp_flag;
uint32_t* light;//simulate, it is unit8
int lambda=8;
BOBHash* bobhash_;
int M2;

public:
	Elastic(int table_num,int bucket_num,int cell_num,int light_num){ 
		table=table_num;
		bucket=bucket_num;
		cell=cell_num;
		M2=light_num;
		bobhash_=new BOBHash(1005);
		nvote= new uint32_t*[table_num];
		for(int i=0;i<table_num;i++){
			nvote[i]= new uint32_t[bucket_num]{0};
		}
		flag= new bool**[table_num];
		for(int i=0;i<table_num;i++){
			flag[i]= new bool*[bucket_num];
			for(int j=0;j<bucket_num;j++){
				flag[i][j]=new bool[cell_num]{0};
			}
		}
		temp_flag=new bool[cell_num]{0};
		light=new uint32_t[M2]{0};
    }
    //void AlgorithmInterface(int32_t &num,std::string &oldstr,std::string newstr){
    //}
	void insert(int table_id, int bucket_id, int cell_id, bool havekey,unsigned int newkey) {
		//Do not perform any operation
	}
	int conflict(int table_id, int bucket_id, int cell_id, int num, bool havekey,unsigned int newkey,unsigned int oldkey) {
		nvote[table_id][bucket_id]++;
		unsigned int oldtemphash = oldkey % M2;
		unsigned int temphash = newkey % M2;
		if (num*lambda<=nvote[table_id][bucket_id]) {
			if(flag[table_id][bucket_id][cell_id]==0){
				if(num>=255){
					light[oldtemphash]=255;
				}else{
					light[oldtemphash]=num;
				}
			}else{
				if(num+light[oldtemphash]>=255){
					light[oldtemphash]=255;
				}else{
					light[oldtemphash]+=num;
				}
			}
			nvote[table_id][bucket_id]=0;
			flag[table_id][bucket_id][cell_id]=1;
			return 1;
		}else{
			if(light[temphash]+1<=255){
				light[temphash]++;
			}
			return 0;
		}
		
	}
	void kickout(int table_id, int bucket_id, int cell_id,int num,unsigned int newkey,unsigned int oldkey,bool realkick){
		unsigned int oldtemphash = oldkey % M2;
		unsigned int temphash = newkey % M2;
		if(realkick){
			if(num>1){
				if(flag[table_id][bucket_id][cell_id]==0){
					if(num>=255){
						light[oldtemphash]=255;
					}else{
						light[oldtemphash]=num;
					}
				}else{
					if(num+light[oldtemphash]>255){
						light[oldtemphash]=255;
					}else{
						light[oldtemphash]+=num;
					}
				}
				flag[table_id][bucket_id][cell_id]=1;
			}else{
				if(light[oldtemphash]+1<=255){
					light[oldtemphash]++;
				}
			}
		}else{
			if(light[temphash]+1<=255){
				light[temphash]++;
			}
		}
	}

	int query(int table_id,int bucket_id,int cell_id,unsigned int key){
		unsigned int temphash = key % M2;
		if(table_id==-1){//only read light part
			return light[temphash];
		}
		if (flag[table_id][bucket_id][cell_id] == 1) {
			return light[temphash];
		}
		return 0;
	}

	void change(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did) {
		int temp=flag[table_did][bucket_did][cell_did];
		flag[table_did][bucket_did][cell_did]=flag[table_sid][bucket_sid][cell_sid];
		flag[table_sid][bucket_sid][cell_sid]=temp;
	}

	void write(int table_sid,int bucket_sid,int cell_sid,int table_did,int bucket_did,int cell_did) {
		flag[table_did][bucket_did][cell_did]=flag[table_sid][bucket_sid][cell_sid];
		flag[table_sid][bucket_sid][cell_sid]=0;
	}

	void write_temp(int table_sid, int bucket_sid, int cell_sid,int pos){
		if(table_sid==-1){
			temp_flag[pos]=false;
		}else{
			temp_flag[pos]=flag[table_sid][bucket_sid][cell_sid];
		}
	}

	void reslove_temp(int table_did,int bucket_did){
		for(int i=0;i<cell;i++){
			flag[table_did][bucket_did][i]=temp_flag[i];
			temp_flag[i]=0;
		}
	}

	void clear() {
		for (int i = 0; i < table; ++i) {
        	for (int j = 0; j < bucket; ++j) {
				for(int k=0;k<cell;k++){
					flag[i][j][k]=0;
				}
				nvote[i][j]=0;
        	    //delete[] nvote[i][j];
        	}
        	//delete[] nvote[i];
    	}
		//delete[] nvote;
	}
};
////2

class Waving : public UseSketch{
private:
bool ***flag;
bool ***is_1;
bool *temp_flag;
bool *temp_is_1;
uint32_t **count;
int table,bucket,cell;
public:
	Waving(int table_num,int bucket_num,int cell_num){
		table=table_num,bucket=bucket_num,cell=cell_num;
		flag = new bool**[table_num];
		for(int i=0;i<table_num;i++){
			flag[i]= new bool*[bucket_num];
			for(int j=0;j<bucket_num;j++){
				flag[i][j] = new bool[cell_num]{false};
			}
		}	
		temp_flag= new bool[cell_num]{false};
		is_1 = new bool**[table_num];
		for(int i=0;i<table_num;i++){
			is_1[i]= new bool*[bucket_num];
			for(int j=0;j<bucket_num;j++){
				is_1[i][j] = new bool[cell_num]{false};
			}
		}		
		temp_is_1=new bool[cell_num]{false};
		count = new uint32_t*[table_num];
		for(int i=0;i<table_num;i++){
			count[i] = new uint32_t[bucket_num]{0};
		}
	}
	void insert(int table_id, int bucket_id, int cell_id, bool havekey,unsigned int newkey) {
		int sign = (newkey & 1) ? 1 : -1;
		if(havekey==false){
			flag[table_id][bucket_id][cell_id] = true;
			is_1[table_id][bucket_id][cell_id] = (sign==1) ? true:false;
		}else{
			if (!flag[table_id][bucket_id][cell_id]){
				count[table_id][bucket_id]+=sign;
			}
		}
	}
	int conflict(int table_id, int bucket_id, int cell_id, int num, bool havekey, unsigned int newkey,unsigned int oldkey) {
		int sign = (newkey & 1) ? 1 : -1;
		if(count[table_id][bucket_id]*sign>=num){
			if(flag[table_id][bucket_id][cell_id]){
				int signold = is_1[table_id][bucket_id][cell_id] ? 1 : -1;//based on have key
				count[table_id][bucket_id] += signold*num;
			}
			num+=1;
			is_1[table_id][bucket_id][cell_id] = (sign==1) ? true:false;
			flag[table_id][bucket_id][cell_id] = false;
			count[table_id][bucket_id] += sign;
			return num;
		}
		count[table_id][bucket_id] += sign;
		return 0;
	}

	void change(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did) {
		bool temp=flag[table_did][bucket_did][cell_did];
		flag[table_did][bucket_did][cell_did]=flag[table_sid][bucket_sid][cell_sid];
		flag[table_sid][bucket_sid][cell_sid]=temp;
		temp=is_1[table_did][bucket_did][cell_did];
		is_1[table_did][bucket_did][cell_did]=is_1[table_sid][bucket_sid][cell_sid];
		is_1[table_sid][bucket_sid][cell_sid]=temp;
	}

	void kickout(int table_id, int bucket_id, int cell_id,int num,unsigned int newkey,unsigned int oldkey,bool realkick){

	}

	void write(int table_sid,int bucket_sid,int cell_sid,int table_did,int bucket_did,int cell_did) {
		flag[table_did][bucket_did][cell_did]=flag[table_sid][bucket_sid][cell_sid];
		is_1[table_did][bucket_did][cell_did]=is_1[table_sid][bucket_sid][cell_sid];
		is_1[table_sid][bucket_sid][cell_sid]=0;
		flag[table_sid][bucket_sid][cell_sid]=0;
	}

	void write_temp(int table_sid, int bucket_sid, int cell_sid,int pos){
		if(table_sid==-1){
			temp_flag[pos]=false;
			temp_is_1[pos]=false;
		}else{
			temp_flag[pos]=flag[table_sid][bucket_sid][cell_sid];
			temp_is_1[pos]=is_1[table_sid][bucket_sid][cell_sid];
		}
	}

	void reslove_temp(int table_did,int bucket_did){
		for(int i=0;i<cell;i++){
			flag[table_did][bucket_did][i]=temp_flag[i];
			temp_flag[i]=0;
			is_1[table_did][bucket_did][i]=temp_is_1[i];
			temp_is_1[i]=0;
		}
	}

	int query(int table_id,int bucket_id,int cell_id,unsigned int key){
		return 0;
	}

	void clear() {
		for (int i = 0; i < table; ++i) {
        	for (int j = 0; j < bucket; ++j) {
				for(int k=0;k<cell;k++){
					flag[i][j][k]=0;
				}
        	    //delete[] flag[i][j];
        	}
        	//delete[] flag[i];
    	}
		//delete[] flag;

		for(int i=0;i<table;++i){
			for(int j=0;j<bucket;j++){
				count[i][j]=0;
			}
			//delete count[i];
		}
		//delete count;
	}
};

class RAP : public UseSketch {
public:
    RAP() {}

    void insert(int table_id, int bucket_id, int cell_id, bool havekey,unsigned int newkey)  {
        // Do not perform any operation
    }

    int conflict(int table_id, int bucket_id, int cell_id, int num, bool havekey,unsigned int newkey,unsigned int oldkey)  {
		if(num==0) return false;
        if (!(rand()%(num))) { // RAP replacement
            num++;
            return true;
        }
        return false;
    }

    void change(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did)  {
        // Do not perform any operation
    }

    void write(int table_sid, int bucket_sid, int cell_sid, int table_did, int bucket_did, int cell_did)  {
        // Do not perform any operation
    }
	
	void kickout(int table_id, int bucket_id, int cell_id,int num,unsigned int newkey,unsigned int oldkey,bool realkick){

	}

	void write_temp(int table_sid, int bucket_sid, int cell_sid,int pos){

	}

	void reslove_temp(int table_did,int bucket_did){

	}

	int query(int table_id,int bucket_id,int cell_id,unsigned int key){
		return 0;
	}

    void clear()  {
		
    }
};
#endif