#ifndef _DHS_H
#define _DHS_H

#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string.h>
#include <stdint.h>
#include <random>
#include <string>
#include <memory>
#include <iostream>
#include <cmath>
#include <math.h>
#include<time.h>
#include<unordered_map>
#include<algorithm>
#include<fstream>
#include "UseSketch.h"
#include "BOBHash.h"

using namespace std;

#define START_FILE_NO 2
#define END_FILE_NO 2

#define landa_h 16
#define test_cycles 1
#define k 1000
#define c1 1 
#define c2 1
#define c3 1

inline unsigned char finger_print_8(unsigned int hash)
{
	hash ^= hash >> 16;
	hash *= 0x85ebca6b;
	hash ^= hash >> 13;
	hash *= 0xc2b2ae35;
	hash ^= hash >> 16;
	//return hash & 65535;
	return hash & 255;
}

class hg_node
{
public:
	vector<unsigned char>heavy;
	unsigned int usage;
	hg_node()
	{
		heavy = vector<unsigned char>(landa_h, 0);
		usage = 0;
	}
};

class DHS
{
private:
	hg_node * bucket;
	BOBHash * bobhash;
	uint bucket_num;
	double b = 1.08;
	UseSketch* test;
public:
	DHS(int memory,int sketch){
		switch(sketch){
			case 1:{
				bucket_num=int(memory/(128+8+32));
				int m2=int(memory*0.75/8);
				cout<<"DHS_Elastic: table num"<<1<<"bucket num"<<bucket_num<<"light part"<<m2<<"cell num"<<8<<endl;
				test=new Elastic(1,bucket_num,8,m2);
				break;
			}
			case 2:{
				bucket_num=int(memory/(128+8*2+32));
				cout<<"DHS_Waving: table num"<<1<<"bucket num"<<bucket_num<<" cell num"<<8<<endl;
				test=new Waving(1,bucket_num,8);
				break;
			}
			case 3:{
				bucket_num=int(memory/128);
				cout<<"DHS_RAP: table num"<<1<<"bucket num"<<bucket_num<<" cell num"<<8<<endl;
				test=new RAP();
				break;
			}
			//default:{
			//	int bucket_len=64;
			//	bucket_num=memory/bucket_len/2;//two tables
			//}
		}
		//bucket_num=int(memory/128);
		bobhash = new BOBHash(750);
		bucket = new hg_node[bucket_num];
	}
	void levelup(int level, int f, int idx,int bucket_idx,const char* str)
	{
		int long_fp=smallhash(f,bucket_idx);
		double ran = 1.0 * rand() / RAND_MAX;
		switch(level)
		{
			case 1:
				{
					int num3 = (bucket[bucket_idx].usage>>8) & 15;
					int num4 = (bucket[bucket_idx].usage>>16) & 15;
					int num2 = landa_h/2 - num4*2 - num3*3/2;
					int usage2 = bucket[bucket_idx].usage & 255;
					int start = 0;
					int end = start + num2*2;
					if(usage2 < num2)//exist empty space
					{
						for(int i = start;i<end;i+=2)
						{
							
							if(bucket[bucket_idx].heavy[i] == 0 && bucket[bucket_idx].heavy[i+1] == 0)
							{
								int cell_idx=int(i/2);
								bucket[bucket_idx].heavy[i] = f&255;
								bucket[bucket_idx].heavy[i+1] = 1;
								bucket[bucket_idx].usage += 1;
								test->insert(0,bucket_idx,cell_idx,false,long_fp);
								return;
							}
						}
					}
					else //no empty space
					{
						//find weakest guardian
						if(num2 == 0)return;
						int min_f = -1;
						int min_fq = -1;
						for(int i = start;i<end;i+=2)
						{
							
							if(min_f == -1)
							{
								min_f = i;
								min_fq = bucket[bucket_idx].heavy[i+1];
							}
							else if(bucket[bucket_idx].heavy[i+1] < min_fq)
							{
								min_f = i;
								min_fq = bucket[bucket_idx].heavy[i+1];
							}
						}
						//exponential decay
						int old_long_fp=smallhash(bucket[bucket_idx].heavy[min_f],bucket_idx);
						int new_num=test->conflict(0,bucket_idx,int(min_f/2),min_fq,true,long_fp,old_long_fp);
						if(new_num!=0){
							if ( new_num >=255 ) {
								// Overflow happens, we try to move the counter to other location
								levelup(2, f, min_f,bucket_idx,str);
								return;
							}else{
								bucket[bucket_idx].heavy[min_f] = (f&255);
								bucket[bucket_idx].heavy[min_f+1] = new_num;
							}
						}
					}
					break;
				}
			case 2:
				{
					if(ran > c2)return;
					int cell_idx=int(idx/2);
					int num3 = (bucket[bucket_idx].usage>>8) & 15;
					int num4 = (bucket[bucket_idx].usage>>16) & 15;
					int num2 = landa_h/2 - num4*2 - num3*3/2;
					int usage2 = bucket[bucket_idx].usage & 255;
					int usage3 = (bucket[bucket_idx].usage>>12) & 15;
					int pos=0,pos_new=0;
					int offset=0;
					//cout<<"level 3"<<endl;
					if(num3 == usage3 && num2 > 3)
					{
						offset=1;
						int usage4 = (bucket[bucket_idx].usage>>20) & 15;
						for(int i=num2;i<num2+num3+num4;i++){
							test->write_temp(0,bucket_idx,i,i-1);//3，4
						}
						num3 += 2;
						num2 -= 3;
						test->write_temp(0,bucket_idx,cell_idx,num2+num3);
						int rest = 0;
						if(usage2 > num2)
						{
							rest = usage2 - num2;
							usage2 = num2;
						}
						//rest == 0: nothing happen
						//rest > 0: kill minimum rest entreis
						if(rest)
						{
							vector<int> weaks(rest, -1);
							vector<int> widx(rest, -1);
							for(int i = 0; i< (num2+3)*2; i+=2)
							{
								
								for(int j = 0; j<rest; j++)
								{
									if(widx[j] == -1)
									{
										widx[j] = i;
										weaks[j] = bucket[bucket_idx].heavy[i+1];
										break;
									}
									else if(bucket[bucket_idx].heavy[i+1] < weaks[j] && bucket[bucket_idx].heavy[i+1] > 0)
									{
										for(int l = rest-1; l>j; l--)
										{
											widx[l] = widx[l-1];
											weaks[l] = weaks[l-1];
										}
										widx[j] = i;
										weaks[j] = bucket[bucket_idx].heavy[i+1];
										break;
									}
								}
							}
							int kill = 0;
							sort(widx.begin(), widx.end());
							for(int i = widx[kill]; i< (num2+3)*2; i+=2)
							{
								
								if(i == widx[kill])
								{
									kill++;
									bucket[bucket_idx].heavy[i] = 0;
									bucket[bucket_idx].heavy[i+1] = 0;
									continue;
								}
								else if(kill)
								{
									bucket[bucket_idx].heavy[i-kill*2] = bucket[bucket_idx].heavy[i];
									bucket[bucket_idx].heavy[i+1-kill*2] = bucket[bucket_idx].heavy[i+1];
									bucket[bucket_idx].heavy[i] = 0;
									bucket[bucket_idx].heavy[i+1] = 0;
									test->write_temp(0,bucket_idx,pos,pos_new);
									pos_new++;
								}else{
									test->write_temp(0,bucket_idx,pos,pos_new);
									pos_new++;
								}
								pos++;
							}
						}
						
						bucket[bucket_idx].usage = 0;
						bucket[bucket_idx].usage += usage2;
						bucket[bucket_idx].usage += (num3<<8);
						bucket[bucket_idx].usage += (usage3<<12);
						bucket[bucket_idx].usage += (num4<<16);
						bucket[bucket_idx].usage += (usage4<<20);
					}
					
					
					int start = num2*2;
					int end = start + num3*3;
					if(usage3 < num3)//exist empty space
					{
						pos=num2;
						for(int i = start;i<end;i+=3)
						{
							
							if(bucket[bucket_idx].heavy[i] == 0 && bucket[bucket_idx].heavy[i+1] == 0 && bucket[bucket_idx].heavy[i+2] == 0)
							{
								f &= 4095; 
								bucket[bucket_idx].heavy[i] = (f>>4);
								bucket[bucket_idx].heavy[i+1] = ((f&15)<<4) + 1;
								bucket[bucket_idx].heavy[i+2] = 0;
								if(offset){
									test->reslove_temp(0,bucket_idx);
								}else{
									test->write(0,bucket_idx,cell_idx,0,bucket_idx,pos);
								}
								bucket[bucket_idx].usage += (1<<12);
								return;
							}
						}
					}
					else //no empty space
					{
						//find weakest guardian
						int min_f = -1;
						int min_fq = -1;
						for(int i = start;i<end;i+=2)
						{
							int freq = ((int)(bucket[bucket_idx].heavy[i+1]&15)<<8)+bucket[bucket_idx].heavy[i+2];
							if(min_f == -1)
							{
								pos=(i-start)/2+num2;
								min_f = i;
								min_fq = freq;
							}
							else if(freq < min_fq && freq>0)
							{
								pos=(i-start)/2+num2;
								min_f = i;
								min_fq = freq;
							}
						}
						//exponential decay
						if (ran < pow(b, log2(min_fq) * -1))
						{
							min_fq -= 1; 
							if(min_fq <= 255)
							{
								f &= 4095; 
								bucket[bucket_idx].heavy[min_f] = (f>>4);
								bucket[bucket_idx].heavy[min_f+1] = ((f&15)<<4) + 1;
								bucket[bucket_idx].heavy[min_f+2] = 0;
								test->write(0,bucket_idx,cell_idx,0,bucket_idx,pos);
							}
							else
							{
								bucket[bucket_idx].heavy[min_f+1] = (bucket[bucket_idx].heavy[min_f+1]&240)+(min_fq>>8);
								bucket[bucket_idx].heavy[min_f+2] = (min_fq&255); 
							}
						}
					}
					break;
				}
			case 3:
				{
					if(ran > c3)return;
					int num3 = (bucket[bucket_idx].usage>>8) & 15;
					int num4 = (bucket[bucket_idx].usage>>16) & 15;
					int num2 = landa_h/2 - num4*2 - num3*3/2;
					int offset=0;
					int cell_idx=int((idx-num2*2)/3+num2);
					int usage2 = bucket[bucket_idx].usage & 255;
					int usage3 = (bucket[bucket_idx].usage>>12) & 15;
					int usage4 = (bucket[bucket_idx].usage>>20) & 15;
					//cout<<"level 4"<<endl;
					int pos_new=0,pos=0;
					if(num4 == usage4)
					{
						if(num2 > 2)
						{
							bucket[bucket_idx].heavy[idx] = 0;
							bucket[bucket_idx].heavy[idx+1] = 0;
							bucket[bucket_idx].heavy[idx+2] = 0;
							for(int i=num2+num3;i<num2+num3+num4;i++){
								test->write_temp(0,bucket_idx,i,i-1);
							}
							offset=1;
							usage3 -= 1;
							num4 += 1;
							num2 -= 2;
							test->write_temp(0,bucket_idx,cell_idx,num2+num3);
							offset=1;
							int rest = 0;
							if(usage2 > num2)
							{
								rest = usage2 - num2;
								usage2 = num2;
							}
							//rest == 0: nothing happen
	
							//rest > 0: kill minimum rest entreis
							if(rest)
							{
								vector<int> weaks(rest, -1);
								vector<int> widx(rest, -1);
								for(int i = 0; i< (num2+2)*2; i+=2)
								{
									
									for(int j = 0; j<rest; j++)
									{
										if(widx[j] == -1)
										{
											widx[j] = i;
											weaks[j] = bucket[bucket_idx].heavy[i+1];
											break;
										}
										else if(bucket[bucket_idx].heavy[i+1] < weaks[j] && bucket[bucket_idx].heavy[i+1] > 0)
										{
											for(int l = rest-1; l>j; l--)
											{
												widx[l] = widx[l-1];
												weaks[l] = weaks[l-1];
											}
											widx[j] = i;
											weaks[j] = bucket[bucket_idx].heavy[i+1];
											break;
										}
									}
								}
								int kill = 0;
								sort(widx.begin(), widx.end());
								for(int i = 0; i< (num2+2)*2; i+=2)
								{
									if(i == widx[kill])
									{
										kill++;
										bucket[bucket_idx].heavy[i] = 0;
										bucket[bucket_idx].heavy[i+1] = 0;
										continue;
									}
									else if(kill)
									{
										bucket[bucket_idx].heavy[i-kill*2] = bucket[bucket_idx].heavy[i];
										bucket[bucket_idx].heavy[i+1-kill*2] = bucket[bucket_idx].heavy[i+1];
										bucket[bucket_idx].heavy[i] = 0;
										bucket[bucket_idx].heavy[i+1] = 0;
										test->write_temp(0,bucket_idx,pos,pos_new);
										pos_new++;
									}else{
										test->write_temp(0,bucket_idx,pos,pos_new);
										pos_new++;
									}
									pos++;
								}
							}
							for(int i = (num2+2)*2; i<(num2+2)*2+num3*3; i+=3)
							{
								
								bucket[bucket_idx].heavy[i-4] = bucket[bucket_idx].heavy[i];
								bucket[bucket_idx].heavy[i+1-4] = bucket[bucket_idx].heavy[i+1];
								bucket[bucket_idx].heavy[i+2-4] = bucket[bucket_idx].heavy[i+2];
								bucket[bucket_idx].heavy[i] = 0;
								bucket[bucket_idx].heavy[i+1] = 0;
								bucket[bucket_idx].heavy[i+2] = 0;
								if(pos==cell_idx){
									test->write_temp(-1,0,0,pos_new);
								}else{
									test->write_temp(0,bucket_idx,pos,pos_new);
								}						
								pos_new++,pos++;
							}
							bucket[bucket_idx].usage = 0;
							bucket[bucket_idx].usage += usage2;
							bucket[bucket_idx].usage += (num3<<8);
							bucket[bucket_idx].usage += (usage3<<12);
							bucket[bucket_idx].usage += (num4<<16);
							bucket[bucket_idx].usage += (usage4<<20);
						} 
						else if(num3 > 4)
						{
							bucket[bucket_idx].heavy[idx] = 0;
							bucket[bucket_idx].heavy[idx+1] = 0;
							bucket[bucket_idx].heavy[idx+2] = 0;
							for(int i=num2+num3;i<num2+num3+num4;i++){
								test->write_temp(0,bucket_idx,i,i-1);
							}
							usage3 -= 1;
							num4 += 3;
							num3 -= 4;
							test->write_temp(0,bucket_idx,cell_idx,num2+num3);
							offset=1;
							int rest = 0;
							if(usage3 > num3)
							{
								rest = usage3 - num3;
								usage3 = num3;
							}	
							//rest == 0: nothing happen
							rest = 4; //different distribution of level-3 empty space
							//rest > 0: kill minimum rest entreis
							if(rest)
							{
								vector<int> weaks(rest, -1);
								vector<int> widx(rest, -1);
								for(int i=0;i<num2;i++){
									test->write_temp(0,bucket_idx,i,i);								
								}
								pos_new=num2;
								pos=num2;	
								for(int i = num2*2; i< num2*2 + (num3+4)*3; i+=3)
								{
									if(i >= landa_h)printf("error warning!\n");
									int a = ((int)(bucket[bucket_idx].heavy[i+1]&15)<<8)+bucket[bucket_idx].heavy[i+2];
									for(int j = 0; j<rest; j++)
									{
										if(widx[j] == -1)
										{
											widx[j] = i;
											weaks[j] = a;
											break;
										}
										else if(a < weaks[j])
										{
											for(int l = rest-1; l>j; l--)
											{
												widx[l] = widx[l-1];
												weaks[l] = weaks[l-1];
											}
											widx[j] = i;
											weaks[j] = a;
											break;
										}
									}
								}
								int kill = 0;
								sort(widx.begin(), widx.end());
								for(int i = num2*2; i< num2*2 + (num3+4)*3; i+=3)
								{
									if(i == widx[kill])
									{
										kill++;
										bucket[bucket_idx].heavy[i] = 0;
										bucket[bucket_idx].heavy[i+1] = 0;
										bucket[bucket_idx].heavy[i+2] = 0;
										continue;
									}
									else if(kill)
									{
										bucket[bucket_idx].heavy[i-kill*3] = bucket[bucket_idx].heavy[i];
										bucket[bucket_idx].heavy[i+1-kill*3] = bucket[bucket_idx].heavy[i+1];
										bucket[bucket_idx].heavy[i+2-kill*3] = bucket[bucket_idx].heavy[i+2];
										bucket[bucket_idx].heavy[i] = 0;
										bucket[bucket_idx].heavy[i+1] = 0;
										bucket[bucket_idx].heavy[i+2] = 0;
										test->write_temp(0,bucket_idx,pos,pos_new);
										pos_new++;
									}else{
										test->write_temp(0,bucket_idx,pos,pos_new);
										pos_new++;
									}
									pos++;
								}
							}
							
							bucket[bucket_idx].usage = 0;
							bucket[bucket_idx].usage += usage2;
							bucket[bucket_idx].usage += (num3<<8);
							bucket[bucket_idx].usage += (usage3<<12);
							bucket[bucket_idx].usage += (num4<<16);
							bucket[bucket_idx].usage += (usage4<<20);
						}
					}
					else if(num4 > usage4)
					{
						pos=num2+num3;
						bucket[bucket_idx].heavy[idx] = 0;
						bucket[bucket_idx].heavy[idx+1] = 0;
						bucket[bucket_idx].heavy[idx+2] = 0;
						usage3 -= 1;
					}
					
					
					int start = num2*2 + num3*3;
					int end = start + num4*4;
					if(usage4 < num4)//exist empty space
					{
						for(int i = start;i<end;i+=4)
						{
							if(bucket[bucket_idx].heavy[i] == 0 && bucket[bucket_idx].heavy[i+1] == 0 && bucket[bucket_idx].heavy[i+2] == 0 && bucket[bucket_idx].heavy[i+3] == 0)
							{
								bucket[bucket_idx].heavy[i] = (f>>8);
								bucket[bucket_idx].heavy[i+1] = f&255;
								bucket[bucket_idx].heavy[i+2] = 16;
								bucket[bucket_idx].heavy[i+3] = 0; 
								bucket[bucket_idx].usage += (1<<20);
								if(offset){
									test->reslove_temp(0,bucket_idx);
								}else{
									test->write(0,bucket_idx,cell_idx,0,bucket_idx,pos);
								}
								return;
							}
							pos++;
						}
						//cout<<"error warning 4!"<<endl;
						//cout<<"status"<<usage2<<" "<<num2<<" "<<usage3<<" "<<num3<<" "<<usage4<<" "<<num4<<endl;
					}
					else //no empty space
					{
						if(num4 == 0)return;
						//find weakest guardian
						int min_f = -1;
						int min_fq = -1;
						pos=-1;
						for(int i = start;i<end;i+=4)
						{
							int freq = ((int)bucket[bucket_idx].heavy[i+2]<<8)+bucket[bucket_idx].heavy[i+3];
							if(min_f == -1)
							{
								pos=(i-start)/4+num2+num3;
								min_f = i;
								min_fq = freq;
							}
							else if(freq < min_fq && freq>0)
							{	
								pos=(i-start)/4+num2+num3;
								min_f = i;
								min_fq = freq;
							}
						}
						//exponential decay
						if (ran < pow(b, log2(min_fq) * -1))
						{
							min_fq -= 1; 
							if(min_fq <= 4095)
							{
								test->write(0,bucket_idx,cell_idx,0,bucket_idx,pos);
								bucket[bucket_idx].heavy[min_f] = (f>>8);
								bucket[bucket_idx].heavy[min_f+1] = f&255;
								bucket[bucket_idx].heavy[min_f+2] = 16;
								bucket[bucket_idx].heavy[min_f+3] = 0;
								
							}
							else
							{
								bucket[bucket_idx].heavy[min_f+2] = (min_fq>>8);
								bucket[bucket_idx].heavy[min_f+3] = (min_fq&255); 
							}
						}
					}
					break;
				}
			default:break;
		}
		return; 
	}
	void Insert(const char * str)
	{
		unsigned int hash = bobhash->run(str, KEY_LEN);
		unsigned short f=finger_print_8(hash);
		int bucket_idx=hash % bucket_num;
		int long_fp=smallhash(f,bucket_idx);
		int num3 = (bucket[bucket_idx].usage>>8) & 15;
		int num4 = (bucket[bucket_idx].usage>>16) & 15;
		int num2 = landa_h/2 - num4*2 - num3*3/2;
		int usage2 = bucket[bucket_idx].usage & 255;
			//level 4
		int start = num2*2+num3*3;
		int pos=num2+num3;
		int end = start + num4*4;
		for(int i = start;i<end;i+=4)	//level 4---- 16bits fingerprint
		{
			
			unsigned short e = ((unsigned short)bucket[bucket_idx].heavy[i]<<8)+bucket[bucket_idx].heavy[i+1];
			if(e==f && (bucket[bucket_idx].heavy[i+2] +bucket[bucket_idx].heavy[i+3] > 0))
			{
				if(bucket[bucket_idx].heavy[i+3]<255){
					test->insert(0,bucket_idx,pos,true,long_fp);
					bucket[bucket_idx].heavy[i+3]++;
				}
				else if(bucket[bucket_idx].heavy[i+2]!=255)
				{
					test->insert(0,bucket_idx,pos,true,long_fp);
					bucket[bucket_idx].heavy[i+2]++;
					bucket[bucket_idx].heavy[i+3] = 0;
				}
				else
				{
					levelup(4, f, i,bucket_idx,str);
				}
				return;
			}
			pos++;
		}
			//level 3
		start = num2*2;
		end = start + num3*3;
		pos=num2;
		for(int i = start;i<end;i+=3)	//level 3---- 12bits fingerprint
		{
			
			unsigned short e = ((unsigned short)bucket[bucket_idx].heavy[i]<<4)+(bucket[bucket_idx].heavy[i+1]>>4);
			if(e==(f&4095) && ((bucket[bucket_idx].heavy[i+1] & 15) + bucket[bucket_idx].heavy[i+2] > 0))
			{
				if(bucket[bucket_idx].heavy[i+2]<255){
					test->insert(0,bucket_idx,pos,true,long_fp);
					bucket[bucket_idx].heavy[i+2]++;
				}
				else if((bucket[bucket_idx].heavy[i+1] & 15)!= 15)
				{
					test->insert(0,bucket_idx,pos,true,long_fp);
					bucket[bucket_idx].heavy[i+1]++;
					bucket[bucket_idx].heavy[i+2] = 0;
				}
				else
				{
					levelup(3, f, i,bucket_idx,str);
				}
				return;
			}
			pos++;
		}
			//level 2
		start = 0;
		end = start + num2*2;
		pos=0;
		for(int i = start;i<end;i+=2)	//level 2---- 8bits fingerprint
		{
			
			unsigned short e = bucket[bucket_idx].heavy[i];
			if(e==(f&255) && bucket[bucket_idx].heavy[i+1] > 0)
			{
				if(bucket[bucket_idx].heavy[i+1]<255){
					test->insert(0,bucket_idx,pos,true,long_fp);
					bucket[bucket_idx].heavy[i+1]++;
				}
				else
				{
					levelup(2, f, i,bucket_idx,str);
				}
				return;
			}
			pos++;
		}
		
		//no existing flow
		levelup(1, f, 0,bucket_idx,str);
	}

	int Query(const char * str)
	{
		unsigned int hash = bobhash->run(str, KEY_LEN);
		unsigned short f=finger_print_8(hash);
		int bucket_idx=hash % bucket_num;
		int long_fp=smallhash(f,bucket_idx);
		int num3 = (bucket[bucket_idx].usage>>8) & 15;
		int num4 = (bucket[bucket_idx].usage>>16) & 15;
		int num2 = landa_h/2 - num4*2 - num3*3/2;
		int usage2 = bucket[bucket_idx].usage & 255;
			//level 4
		int start = num2*2+num3*3;
		int end = start + num4*4;
		for(int i = start;i<end;i+=4)
		{
			unsigned short e = ((unsigned short)bucket[bucket_idx].heavy[i]<<8)+bucket[bucket_idx].heavy[i+1];
			if(e==f && (bucket[bucket_idx].heavy[i+2] +bucket[bucket_idx].heavy[i+3] > 0))
			{
				return ((int)bucket[bucket_idx].heavy[i+2]<<8)+bucket[bucket_idx].heavy[i+3];
			}
		}
			//level 3
		start = num2*2;
		end = start + num3*3;
		for(int i = start;i<end;i+=3)
		{
			unsigned short e = ((unsigned short)bucket[bucket_idx].heavy[i]<<4)+(bucket[bucket_idx].heavy[i+1]>>4);
			if(e==(f&4095) && ((bucket[bucket_idx].heavy[i+1] & 15) + bucket[bucket_idx].heavy[i+2] > 0))
			{
				return ((int)(bucket[bucket_idx].heavy[i+1]&15)<<8)+bucket[bucket_idx].heavy[i+2];
			}
		}
			//level 2
		start = 0;
		end = start + num2*2;
		for(int i = start;i<end;i+=2)
		{
			unsigned short e = bucket[bucket_idx].heavy[i];
			if(e==(f&255) && bucket[bucket_idx].heavy[i+1] > 0)
			{
				return bucket[bucket_idx].heavy[i+1];
			}
		}
		
		//no existing flow
		return 0;
	}
};

#endif//_DHS_H
