#include <stdio.h>
#include <cstdio>
#include <cstdlib>
#include <algorithm>
#include <iostream>
#include <fstream>
#include <unordered_map>
#include <string>
#include <string.h>
#include <ctime>
#include <cstring>
#include <time.h>
#include <iterator>
#include <math.h>
#include <vector>
#include <map>
#include <sstream>
#include "unistd.h"
#include "params.h"
#include "ElasticSketch.h"
#include "BitMatcher.h"
#include "dms4.h"
#include "SwitchSketch.h"
#include "BaseSketch.h"

using namespace std;
//bool debug=true;
BOBHash * testhash;
string testkey;
string resultFile = "None"; 
char filename_stream[60] = "0.dat";
char insert[60000000 + 10000000 / 2][200];
char query[60000000 + 10000000 / 2][200];
unordered_map<string, int> unmp;
#define testcycles 1
DHS *dhsketch;
BitMatcher *bmatcher;
SwitchSketch *switchsketch;
Elasticsketch *elastic;
Basesketch* base;
timespec time1, time2;

void Frequency(int package_num,double memory,int bucket_len,int type_bit,int fingerprint_len,int level_num,int entry_num,int usesketch,int type_num,double hh){
    char temp[200];

    double re_sw = 0.0, re_dhs = 0.0,  re_bm = 0.0,re_el=0.0,re_ba=0.0;
    double re_sw_sum = 0.0, re_dhs_sum = 0.0, re_bm_sum = 0.0,re_el_sum=0.0,re_ba_sum=0.0;
    
    double ae_sw = 0.0, ae_dhs = 0.0,  ae_bm = 0.0,ae_el=0.0,ae_ba=0.0;
    double ae_sw_sum = 0.0, ae_dhs_sum = 0.0, ae_bm_sum = 0.0,ae_el_sum,ae_ba_sum=0.0;

    double val_sw = 0.0, val_dhs = 0.0, val_bm = 0.0,val_el = 0.0,val_ba = 0.0;
    double erro_sw = 0.0, erro_dhs = 0.0, erro_bm = 0.0,erro_el=0.0,erro_ba=0.0;


    int error_num;
    for(unordered_map<string, int>::iterator it = unmp.begin(); it != unmp.end(); it++)
    {
        memcpy(temp, (it->first).c_str(), KEY_LEN);
        int val = it->second;
        if(usesketch!=0){
            val_sw = switchsketch->Query(temp);
            re_sw = fabs(val_sw - val) / (val * 1.0);
            ae_sw = fabs(val_sw - val);
            re_sw_sum += re_sw;
            ae_sw_sum += ae_sw;

            val_dhs = dhsketch->Query(temp);  
            re_dhs = fabs(val_dhs - val) / (val * 1.0); 
            ae_dhs = fabs(val_dhs - val);    
            re_dhs_sum += re_dhs;   
            ae_dhs_sum += ae_dhs; 

            val_ba=base->Query(temp);
            re_ba = fabs(val_ba - val) / (val * 1.0);
            ae_ba = fabs(val_ba - val);
            re_ba_sum += re_ba; 
            ae_ba_sum += ae_ba;       
        }
	    val_bm = bmatcher->Query(temp);
	    re_bm = fabs(val_bm - val) / (val * 1.0);	
	    ae_bm = fabs(val_bm - val);                 
	    re_bm_sum += re_bm;
	    ae_bm_sum += ae_bm;
    }
//
    cout<<error_num<<endl;
    double a = package_num* testcycles * 1.0;
    double b = unmp.size() * 1.0;
    if(resultFile=="None"){
	    //printf("*************************************\n");
        printf("aae_sw = %lf\n", ae_sw_sum / b);
        printf("aae_DHS = %lf\n", ae_dhs_sum / b);
	    printf("aae_BM = %lf\n", ae_bm_sum / b);
        printf("aae_base = %lf\n", ae_ba_sum / b);	
        //printf("*************************************\n");
        printf("are_sw = %lf\n", re_sw_sum / b);
        printf("are_DHS = %lf\n", re_dhs_sum / b);
        printf("are_BM = %lf\n", re_bm_sum / b);
        printf("are_base = %lf\n", re_ba_sum / b); 
    //printf("**************************************\n");
    }else{
        ofstream in(resultFile, ios::app);
        if (in.is_open()) {
            if(usesketch!=0){
	    	    in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "base" <<","<< ae_ba_sum / b << "," << re_ba_sum / b << ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<<"SW" <<","<< ae_sw_sum / b << "," << re_sw_sum / b << ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<<"DHS" <<","<< ae_dhs_sum / b << "," << re_dhs_sum / b << ","<<endl;
            }
            in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<<"BM" <<","<< ae_bm_sum / b << "," << re_bm_sum / b << ","<<endl;
            in.close();
        } else {
            cout << "Unable to open file" << endl;
        }
    }
	printf("Evaluation Ends!\n\n");
}

void HH(int package_num,double hh,double memory,int bucket_len,int type_bit,int fingerprint_len,int level_num,int entry_num,int usesketch,int type_num){
    char temp[105];
    double re_sw = 0.0, re_dhs = 0.0,  re_bm = 0.0,re_el=0.0,re_ba=0.0;
    double re_sw_sum = 0.0, re_dhs_sum = 0.0, re_bm_sum = 0.0,re_el_sum=0.0,re_ba_sum=0.0;
    
    double ae_sw = 0.0, ae_dhs = 0.0,  ae_bm = 0.0,ae_el=0.0,ae_ba=0.0;
    double ae_sw_sum = 0.0, ae_dhs_sum = 0.0, ae_bm_sum = 0.0,ae_el_sum,ae_ba_sum=0.0;

    double val_sw = 0.0, val_dhs = 0.0, val_bm = 0.0,val_el = 0.0,val_ba = 0.0;
    double erro_sw = 0.0, erro_dhs = 0.0, erro_bm = 0.0,erro_el=0.0,erro_ba=0.0;

    double rc_ba = 0.0, rc_dhs = 0.0,  rc_sw = 0.0,  rc_el = 0.0, rc_bm = 0.0;
    double pr_ba = 0.0, pr_dhs = 0.0,  pr_sw = 0.0,  pr_el = 0.0, pr_bm = 0.0;
    double f1_ba = 0.0, f1_dhs = 0.0,  f1_sw = 0.0,  f1_el = 0.0, f1_bm = 0.0;
    double tp_ba = 0.0, tp_dhs = 0.0,  tp_sw = 0.0,  tp_el = 0.0, tp_bm = 0.0;
    double fp_ba = 0.0, fp_dhs = 0.0,  fp_sw = 0.0,  fp_el = 0.0, fp_bm = 0.0;
    double tn_ba = 0.0, tn_dhs = 0.0,  tn_sw = 0.0,  tn_el = 0.0, tn_bm = 0.0;
    double fn_ba = 0.0, fn_dhs = 0.0,  fn_sw = 0.0,  fn_el = 0.0, fn_bm = 0.0;

    int threshold = package_num * testcycles * hh;
    int hh_num = 0,val,query_idx=0;
    for(unordered_map<string, int>::iterator it = unmp.begin(); it != unmp.end(); it++,query_idx++)
    {
        memcpy(temp, (it->first).c_str(), KEY_LEN);
        val = it->second;
    	bool f1_true = 0;
    	bool f2_ba = 0, f2_dhs = 0,  f2_sw = 0,  f2_bm = 0, f2_el=0;

        if(usesketch!=0){
            val_ba = base->Query(temp);   
            val_sw = switchsketch->Query(temp);
            val_dhs = dhsketch->Query(temp); 
        }
        val_bm = bmatcher->Query(temp);

    	if (val >= threshold) {
    		f1_true = 1;
    		hh_num++;
    	}
    	if (val_ba >= threshold) f2_ba = 1;
    	if (val_sw >= threshold) f2_sw = 1;
    	if (val_bm >= threshold) f2_bm = 1;
    	if (val_el >= threshold) f2_el = 1;
        if (val_dhs >= threshold) f2_dhs = 1;

    	if (f1_true) {
            re_ba = fabs(val_ba - val) / (val * 1.0);
            re_sw = fabs(val_sw - val) / (val * 1.0);
            re_bm = fabs(val_bm - val) / (val * 1.0);
            if(re_bm>0.1){
                debug=true;
                bmatcher->Query(temp);
                debug=false;
                cout<<val<<" "<<val_bm<<" "<<re_bm<<" "<<query_idx<<" hash:"<<testhash->run(temp,strlen(temp))<<endl;
            }
    	    re_el = fabs(val_el - val) / (val * 1.0);
            re_dhs = fabs(val_dhs - val) / (val * 1.0);

            ae_ba = fabs(val_ba - val);     
            ae_sw = fabs(val_sw - val);      
            ae_bm = fabs(val_bm - val);       
    	    ae_el = fabs(val_el - val);
            ae_dhs = fabs(val_dhs - val);

            re_ba_sum += re_ba;     
            re_sw_sum += re_sw;      
            re_bm_sum += re_bm;            
    	    re_el_sum += re_el;
            re_dhs_sum += re_dhs;

            ae_ba_sum += ae_ba;    
            ae_sw_sum += ae_sw;       
            ae_bm_sum += ae_bm;      
    	    ae_el_sum += ae_el;
            ae_dhs_sum += ae_dhs;
    	}

    	if (f1_true && f2_ba) tp_ba++;
    	else if (f1_true && !f2_ba) fn_ba++;
    	else if (!f1_true && f2_ba) fp_ba++;
    	else tn_ba++;

    	if (f1_true && f2_sw) tp_sw++;
    	else if (f1_true && !f2_sw) fn_sw++;
    	else if (!f1_true && f2_sw) fp_sw++;
    	else tn_sw++;

    	if (f1_true && f2_bm) tp_bm++;
    	else if (f1_true && !f2_bm){
            fn_bm++;
        } 
    	else if (!f1_true && f2_bm){
            fp_bm++;
        } 
    	else tn_bm++;

    	if (f1_true && f2_el) tp_el++;
    	else if (f1_true && !f2_el) fn_el++;
    	else if (!f1_true && f2_el) fp_el++;
    	else tn_el++;

        if (f1_true && f2_dhs) tp_dhs++;
    	else if (f1_true && !f2_dhs) fn_dhs++;
    	else if (!f1_true && f2_dhs) fp_dhs++;
    	else tn_dhs++;
    }
    double b = hh_num * 1.0;
    if(resultFile=="None"){
    	printf("Heavy Hitter threshold = %d\n",threshold);
    	printf("Heavy Hitter numbers = %d\n", hh_num);

        printf("\n*************** Heavy hitter detection: ****************\n");
     	printf("*************** AAE ****************\n");

        printf("aae_ba = %lf\n", ae_ba_sum / b);
    	printf("aae_sw = %lf\n", ae_sw_sum / b);
        printf("aae_dhs = %lf\n", ae_dhs_sum / b); 
    	printf("aae_el = %lf\n", ae_el_sum / b);
        printf("aae_BM = %lf\n", ae_bm_sum / b);

        printf("******************* ARE ******************\n");

        printf("are_ba = %lf\n", re_ba_sum / b);
    	printf("are_sw = %lf\n", re_sw_sum / b);
        printf("are_dhs = %lf\n", re_dhs_sum / b);
    	printf("are_el = %lf\n", re_el_sum / b); 
        printf("are_BM = %lf\n", re_bm_sum / b);

    	printf("****************** Recall *******************\n");

        printf("recall_ba = %lf\n", tp_ba / (tp_ba + fn_ba));
    	printf("recall_sw = %lf\n", tp_sw / (tp_sw + fn_sw));
        printf("recall_dhs = %lf\n", tp_dhs / (tp_dhs + fn_dhs));
    	printf("recall_el = %lf\n", tp_el / (tp_el + fn_el));
        printf("recall_bm = %lf\n", tp_bm / (tp_bm + fn_bm)); 

    	printf("******************* Precision ******************\n");

        printf("precision_ba = %lf\n", tp_ba / (tp_ba + fp_ba));
    	printf("precision_sw = %lf\n", tp_sw / (tp_sw + fp_sw));
        printf("precision_dhs = %lf\n", tp_dhs / (tp_dhs + fp_dhs));
    	printf("precision_el = %lf\n", tp_el / (tp_el + fp_el));  
        printf("precision_bm = %lf\n", tp_bm / (tp_bm + fp_bm)); 

    	printf("****************** F1 score *******************\n");

    	printf("f1score_ba = %lf\n", 2 * tp_ba / (2 * tp_ba + fp_ba + fn_ba));
    	printf("f1score_sw = %lf\n", 2 * tp_sw / (2 * tp_sw + fp_sw + fn_sw));
        printf("f1score_dhs = %lf\n", 2 * tp_dhs / (2 * tp_dhs + fp_dhs + fn_dhs));
    	printf("f1score_el = %lf\n", 2 * tp_el / (2 * tp_el + fp_el + fn_el)); 
        printf("f1score_BM = %lf\n", 2 * tp_bm / (2 * tp_bm + fp_bm + fn_bm));  

        printf("******************************************************************************\n");
    }else{
        ofstream in(resultFile, ios::app);
        if (in.is_open()) {
            if(usesketch!=0){
	    	    in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "base" <<","<< ae_ba_sum / b << "," << re_ba_sum / b<<","<< tp_ba / (tp_ba + fn_ba)<<","<< tp_ba / (tp_ba + fp_ba)<<","<<2 * tp_ba / (2 * tp_ba + fp_ba + fn_ba)<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "SW" <<","<< ae_sw_sum / b << "," << re_sw_sum / b << ","<< tp_sw / (tp_sw + fn_sw)<<","<< tp_sw / (tp_sw + fp_sw)<<","<<2 * tp_sw / (2 * tp_sw + fp_sw + fn_sw)<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "DHS" <<","<< ae_dhs_sum / b << "," << re_dhs_sum / b << ","<< tp_dhs / (tp_dhs + fn_dhs)<<","<< tp_dhs / (tp_dhs + fp_dhs)<<","<<2 * tp_dhs / (2 * tp_dhs + fp_dhs + fn_dhs)<< ","<<endl;
            }
            in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "BM" <<","<< ae_bm_sum / b << "," << re_bm_sum / b << ","<< tp_bm / (tp_bm + fn_bm)<<","<< tp_bm / (tp_bm + fp_bm)<<","<<2 * tp_bm / (2 * tp_bm + fp_bm + fn_bm)<< ","<<endl;
            in.close();
        } else {
            cout << "Unable to open file" << endl;
        }
    }
    printf("Evaluation Ends!\n\n");
}

void Distribution(int max_freq,int package_num,double memory,int bucket_len,int type_bit,int fingerprint_len,int level_num,int entry_num,int usesketch,int type_num){
    char temp[105];
    double val_sw = 0.0, val_dhs = 0.0, val_bm = 0.0,val_el = 0.0,val_ba = 0.0;
    
    unordered_map<int, double> real_dist;
    unordered_map<int, double> el_dist;
    unordered_map<int, double> bm_dist;
    unordered_map<int, double> dhs_dist;
    unordered_map<int, double> sw_dist;
    unordered_map<int, double> ba_dist;
    int val;

    for(unordered_map<string, int>::iterator it = unmp.begin(); it != unmp.end(); it++)
    {
        memcpy(temp, (it->first).c_str(), KEY_LEN);
        val = it->second;
        real_dist[val]++;
        
        if(usesketch!=0){
            val_ba = base->Query(temp);   
            val_sw = switchsketch->Query(temp);
            val_dhs = dhsketch->Query(temp); 
        }  
        val_bm = bmatcher->Query(temp);

        el_dist[val_el]++;
        bm_dist[val_bm]++;
        dhs_dist[val_dhs]++;
        sw_dist[val_sw]++;
        ba_dist[val_ba]++;
    }

    double zi_el=0.0, zi_bm=0.0, zi_dhs=0.0 ,zi_sw=0.0, zi_ba=0.0;
    double mu_el=0.0, mu_bm=0.0, mu_dhs=0.0,mu_sw=0.0, mu_ba=0.0;

    for (int i=1; i<=max_freq; i++){
        zi_el += fabs(real_dist[i] - el_dist[i]);   
        zi_bm += fabs(real_dist[i] - bm_dist[i]);
        zi_dhs += fabs(real_dist[i] - dhs_dist[i]);
        zi_sw += fabs(real_dist[i] - sw_dist[i]);
        zi_ba += fabs(real_dist[i] - ba_dist[i]);
        mu_el += (real_dist[i] + el_dist[i]) / 2.0;   
        mu_bm += (real_dist[i] + bm_dist[i]) / 2.0;
        mu_dhs += (real_dist[i] + dhs_dist[i]) / 2.0;
        mu_sw += (real_dist[i] + sw_dist[i]) / 2.0;
        mu_ba += (real_dist[i] + ba_dist[i]) / 2.0;
    }


    if(resultFile=="None"){
        printf("WMRE_EL = %lf\n", zi_el/mu_el);
        printf("WMRE_DHS = %lf\n", zi_dhs/mu_dhs);
        printf("WMRE_BM = %lf\n", zi_bm/mu_bm);
        printf("WMRE_SW = %lf\n", zi_sw/mu_sw);
        printf("WMRE_BA = %lf\n", zi_ba/mu_ba);
    
        printf("******************************************************************************\n");
        printf("Evaluation Ends!\n\n");
    }else{
        ofstream in(resultFile, ios::app);
        if (in.is_open()) {
            if(usesketch!=0){
	    	    in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "base" <<","<<zi_ba/mu_ba<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "SW" <<","<<zi_sw/mu_sw<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "DHS" <<","<<zi_dhs/mu_dhs<< ","<<endl;
            }
            in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "BM" <<","<<zi_bm/mu_bm<< ","<<endl;
            in.close();
        } else {
            cout << "Unable to open file" << endl;
        }
    }
}

void Entropy(int package_num,double memory,int bucket_len,int type_bit,int fingerprint_len,int level_num,int entry_num,int usesketch,int type_num){
    package_num=package_num * testcycles;//true packet num
    char temp[105];
    double val_el=0.0, val_bm=0.0, val_dhs=0.0 ,val_sw=0.0, val_ba=0.0;
    
    double real_entropy=0.0;
    double el_entropy=0.0, bm_entropy=0.0, dhs_entropy=0.0,sw_entropy=0.0, ba_entropy=0.0;
    double p_real, p_el, p_bm, p_dhs,p_sw, p_ba;
    
    double sum_el=0.0, sum_bm=0.0, sum_dhs=0.0,sum_sw=0.0, sum_ba=0.0;
    int val;
    for(unordered_map<string, int>::iterator it = unmp.begin(); it != unmp.end(); it++)
    {
        memcpy(temp, (it->first).c_str(), KEY_LEN);
        val = it->second;
        p_real = (double (val)) / package_num;
        real_entropy += p_real*(log2(1/p_real));

        if(usesketch!=0){
            val_bm = bmatcher->Query(temp);
            val_dhs = dhsketch->Query(temp);
            val_sw = switchsketch->Query(temp);
        }
        val_ba = base->Query(temp);

        p_el = val_el / package_num;
        p_bm = val_bm / package_num;
        p_dhs = val_dhs / package_num;
        p_sw = val_sw / package_num;
        p_ba = val_ba / package_num;
        
        el_entropy += p_el == 0 ? 0 : p_el*(log2(1/p_el));
        bm_entropy += p_bm == 0 ? 0 : p_bm*(log2(1/p_bm));
        dhs_entropy += p_dhs == 0 ? 0 : p_dhs*(log2(1/p_dhs));
        sw_entropy += p_sw == 0 ? 0 : p_sw*(log2(1/p_sw));
        ba_entropy += p_ba == 0 ? 0 : p_ba*(log2(1/p_ba));
    }

    if(resultFile=="None"){
        printf("Real_entropy: %lf\n", real_entropy);
        printf("ElasticSketch_entropy = %lf; RE = %lf\n", el_entropy, fabs(real_entropy-el_entropy)/real_entropy);
        printf("DHS_entropy: %lf; RE = %lf\n", dhs_entropy, fabs(real_entropy-dhs_entropy)/real_entropy);
        printf("BitMatcher_entropy: %lf; RE = %lf\n", bm_entropy, fabs(real_entropy-bm_entropy)/real_entropy);
        printf("SwitchSketch_entropy: %lf; RE = %lf\n", sw_entropy, fabs(real_entropy-sw_entropy)/real_entropy);
        printf("BaseSketch_entropy: %lf; RE = %lf\n", ba_entropy, fabs(real_entropy-ba_entropy)/real_entropy);
        printf("*************************************\n");
        printf("Evaluation Ends!\n\n");
    }else{
        ofstream in(resultFile, ios::app);
        if (in.is_open()) {
            if(usesketch!=0){
	    	    in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "base" <<","<<fabs(real_entropy-ba_entropy)/real_entropy<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "SW" <<","<<fabs(real_entropy-sw_entropy)/real_entropy<< ","<<endl;
                in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "DHS" <<","<<fabs(real_entropy-dhs_entropy)/real_entropy<< ","<<endl;
            }
            in << memory*1000 <<"KB"<< ","<< usesketch<< ","<< fingerprint_len<< ","<< bucket_len<< ","<< entry_num<< ","<< type_num<< ","<< type_bit<< ","<< "BM" <<","<<fabs(real_entropy-bm_entropy)/real_entropy<< ","<<endl;
            in.close();
        } else {
            cout << "Unable to open file" << endl;
        }
    }
}

void test(double memory,long long package_num,int bucket_len,int type_bit,int fingerprint_len,int entry_num,int usesketch,int max_freq,int type_num){
    bmatcher = new BitMatcher(memory * 1000 *1024*8,usesketch,bucket_len,type_bit,fingerprint_len,entry_num,type_num);
    bmatcher->Insert(insert[0]);
    int res_tmp = bmatcher->Query(insert[0]);
    cout<<res_tmp;

}

int reslove(double memory,long long package_num,int bucket_len,int type_bit,int fingerprint_len,int entry_num,int usesketch,int max_freq,int type_num,string task,double hh,int level_num)
{
    printf("\n******************************************************************************\n");
    printf("Evaluation starts!\n\n");
/********************************insert*********************************/
    long long resns;
    
    int word_size = 64;
    int w = memory * 1024 * 1024 * 8.0 / COUNTER_SIZE;	//how many counter;
    int w_p = memory * 1024 * 1024 * 8.0 / (word_size * 2);

    int m2_mv = memory * 1024 * 1024 / 4 / 4;
    
    int w_salsa = memory * 1024 * 1024;
    

    int m1 = memory * 1000 * 1024 * 2/(65*BN+32);
    int m2 = memory * 1000 * 1024 * 6/8;

    if(usesketch!=0){
        srand(1);
        base = new Basesketch(memory*1000*1024*8,usesketch,fingerprint_len);
        clock_gettime(CLOCK_MONOTONIC, &time1);
        for(int t = 0; t < testcycles; t++)
        {
            for(int i = 0; i < package_num; i++)
            {
                base->Insert(insert[i]);
            }
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_ba = (double)1000.0 * testcycles * package_num / resns;
        printf("throughput of DHS (insert): %.6lf Mips\n", throughput_ba);

        srand(1);
        int w_dhs = memory * 1000 * 1024 / 16;
        dhsketch = new DHS(memory * 1000 *1024*8,usesketch);
        clock_gettime(CLOCK_MONOTONIC, &time1);
        for(int t = 0; t < testcycles; t++)
        {
            for(int i = 0; i < package_num; i++)
            {
                dhsketch->Insert(insert[i]);
            }
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_dhs = (double)1000.0 * testcycles * package_num / resns;
        printf("throughput of DHS (insert): %.6lf Mips\n", throughput_dhs);

        srand(1);
        switchsketch = new SwitchSketch(memory * 1000 *1024*8,usesketch);
        clock_gettime(CLOCK_MONOTONIC, &time1);
        for(int t = 0; t < testcycles; t++)
        {
            for(int i = 0; i < package_num; i++)
            {
                switchsketch->Insert(insert[i]);
            }
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_switchsketch = (double)1000.0 * testcycles * package_num / resns;
        printf("throughput of SwitchSketch (insert): %.6lf Mips\n", throughput_switchsketch);
    }
//
    srand(1);
    bmatcher = new BitMatcher(memory * 1000 *1024*8,usesketch,bucket_len,type_bit,fingerprint_len,entry_num,type_num,level_num);
	clock_gettime(CLOCK_MONOTONIC, &time1);
    for (int t = 0; t < testcycles; t++)
    {
		    for (int i = 0; i < package_num; i++)
            {
                bmatcher->Insert(insert[i]);
                debug=false;
            }
    }
    clock_gettime(CLOCK_MONOTONIC, &time2);
    resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
    double throughput_bm = (double)1000.0 * testcycles * package_num / resns;
    printf("throughput of BM (insert): %.6lf Mips\n", throughput_bm);



/********************************************************************************************/

    printf("*************************************\n");

/********************************query*********************************/
    double res_tmp=0;
    int flow_num = unmp.size();
    double sum = 0;
    if(usesketch!=0){
        clock_gettime(CLOCK_MONOTONIC, &time1);
        for(int i = 0; i < flow_num; i++)
        {
            res_tmp = base->Query(query[i]);
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_ba = (double)1000.0 * testcycles * flow_num / resns;
        printf("throughput of DHS (query): %.6lf Mips\n", throughput_ba);
        sum += res_tmp;

        clock_gettime(CLOCK_MONOTONIC, &time1);
        for(int i = 0; i < flow_num; i++)
        {
            res_tmp = dhsketch->Query(query[i]);
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_dhs = (double)1000.0 * testcycles * flow_num / resns;
        printf("throughput of DHS (query): %.6lf Mips\n", throughput_dhs);
        sum += res_tmp;
//  
        clock_gettime(CLOCK_MONOTONIC, &time1);
        for (int i = 0; i < flow_num; i++)
        {
            res_tmp = switchsketch->Query(query[i]);
        }
        clock_gettime(CLOCK_MONOTONIC, &time2);
        resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
        double throughput_switchsketch = (double)1000.0 * testcycles * flow_num / resns;
        printf("throughput of SW (query): %.6lf Mips\n", throughput_switchsketch);
        sum += res_tmp;
    }

    clock_gettime(CLOCK_MONOTONIC, &time1);
    for (int i = 0; i < flow_num; i++)
    {
        res_tmp = bmatcher->Query(query[i]);
    }
    clock_gettime(CLOCK_MONOTONIC, &time2);
    resns = (long long)(time2.tv_sec - time1.tv_sec) * 1000000000LL + (time2.tv_nsec - time1.tv_nsec);
    throughput_bm = (double)1000.0 * testcycles * flow_num / resns;
    printf("throughput of BM (query): %.6lf Mips\n", throughput_bm);
    sum += res_tmp;

/********************************************************************************************/
    printf("*************************************\n");
    //
    //avoid the over-optimize of the compiler! 
    if(task=="hh"){
        if(sum == (1 << 30))
            return 0;
        HH(package_num, hh, memory, bucket_len, type_bit, fingerprint_len, level_num, entry_num, usesketch, type_num);
    }else if(task=="frequency"){
        Frequency(package_num,memory,bucket_len,type_bit,fingerprint_len, level_num, entry_num, usesketch, type_num, hh);
    }else if(task=="distribution"){
        Distribution(max_freq,package_num, memory, bucket_len, type_bit, fingerprint_len, level_num, entry_num, usesketch, type_num);
    }else if(task=="entropy"){
        Entropy(package_num, memory, bucket_len, type_bit, fingerprint_len, level_num, entry_num, usesketch, type_num);
    }
    return 0;
}


int main(int argc, char** argv){
    int c;
    long long package_num;
    double memory=0.1,hh=0.00001;
    int bucket_len=64,type_bit=4,fingerprint_len=9,entry_num=5,usesketch=3,type_num=12,level_num=2;
    string task="hh";
	while((c=getopt(argc, argv, "d:o:m:b:t:f:e:u:p:a:h:l:"))!=-1) {
        switch(c) {
            case 'd'://this is the dataset
                strcpy(filename_stream,optarg);
                break;
            case 'o'://this is the output file
                resultFile=optarg;
                break;
            case 'm'://this is the memory in MB
                memory = stod(optarg);
                break;
			case 'b'://The bitnum of bucket
				bucket_len=atoi(optarg);
				break;
			case 't'://bit num of type
				type_bit=atoi(optarg);
				break;
			case 'f'://len of fingerprint
				fingerprint_len=atoi(optarg);
				break;
			case 'e'://start entry num
				entry_num=atoi(optarg);
				break;
            case 'l':
                level_num=atoi(optarg);//level of bitmatcher,only support 1 and 2
                break;
            case 'u'://what type of sketch is used?
                usesketch=atoi(optarg);
                break;
            case 'p'://type num
                type_num=atoi(optarg);
                break;
            case 'a'://[hh,frequency,entropy,distribution]
                task=optarg;
                break;
            case 'h':// hh threshold
                hh=stod(optarg);
                break;
        }
    }
    testhash = new BOBHash(1000);
    int memory_ = memory * 1000;//KB
    printf("\n******************************************************************************\n");
    printf("Read dataset!\n\n");
    unmp.clear();  
    package_num = 0;
    FILE *file_stream = fopen(filename_stream, "r");
    while( fread(insert[package_num], 1, KEY_LEN, file_stream)==KEY_LEN ) //for the rest
    {   
        if(package_num >=MAX_INSERT_PACKAGE)
            break;
        string str = string(insert[package_num], KEY_LEN);
        char temp[200];
        unmp[str]+=testcycles;
        package_num+=1;
    }
    fclose(file_stream);
    printf("memory = %dKB\n", memory_);
    printf("dataset name: %s\n", filename_stream);
    printf("Bucket size:%d Type_len:%d fingerprint_len:%d entry_num:%d \n",bucket_len,type_bit,fingerprint_len,entry_num);
    printf("Use sketch: %d\n Type_num %d\n", usesketch,type_num);
    printf("total stream size = %d\n", package_num*testcycles);
    printf("distinct item number = %d\n", unmp.size());

    int max_freq = 0;
    unordered_map<string, int>::iterator it = unmp.begin();

    for(int i = 0; i < unmp.size(); i++, it++)
    {
        memcpy(query[i], it->first.c_str(), KEY_LEN);

        int temp2 = it->second;
        max_freq = max_freq > temp2 ? max_freq : temp2;
    }
    printf("max_freq = %d\n", max_freq);
    reslove(memory,package_num,bucket_len,type_bit,fingerprint_len,entry_num,usesketch,max_freq,type_num,task,hh,level_num);
}