#ifndef RM_ECS_H
#define RM_ECS_H

#include <stdint.h> // uint32_t

//#define REDIS_MODULE_TARGET
#ifdef REDIS_MODULE_TARGET
#include "redismodule.h"
#define ECS_CALLOC(count, size) RedisModule_Calloc(count, size)
#define ECS_FREE(ptr) RedisModule_Free(ptr)
#else
#define ECS_CALLOC(count, size) calloc(count, size)
#define ECS_FREE(ptr) free(ptr)
#endif

#define EC_d 2
#define BN 4
#define MAX_MEM 100000

typedef struct bucket_ec {
	uint32_t C[5], fingerprint[5];
	uint32_t flag;
} bucket_t;

typedef struct EC {
	size_t width;
	size_t depth;
	bucket_t HK_EC[2][MAX_MEM];
}ECSketch;

void moveforward(bucket_t* b);

/* Creates a new Count-Min Sketch with dimensions of width * depth */
ECSketch *NewECSketch(size_t width, size_t depth);
/*  Recommends width & depth for expected n different items,
    with probability of an error  - prob and over estimation
    error - overEst (use 1 for max aecuracy) */
//void CMS_DimFromProb(double overEst, double prob, size_t *width, size_t *depth);

void ECS_Destroy(ECSketch *ec);

/*  Increases item count in value.
    Value must be a non negative number */
size_t ECS_IncrBy(ECSketch *ec, const char *item, size_t strlen, size_t value);

/* Returns an estimate counter for item */
size_t ECS_Query(ECSketch *ec, const char *item, size_t strlen);
size_t EC_overflow(bucket_t* b, int j);
size_t EC_plus(bucket_t* b, int j);
//void kickout(bucket_t *b,int j);
/*  Merges multiple CMSketches into a single one.
    All sketches must have identical width and depth.
    dest must be already initialized.
*/
//void CMS_Merge(CMSketch *dest, size_t quantity, const CMSketch **src, const long long *weights);
//void CMS_MergeParams(mergeParams params);

/* Help function */
//void CMS_Print(const CMSketch *cms);

#endif
