////////////////////////////////////////////////////////////////////////////////
// Copyright (C) 1999-2008 Easics NV.
// This source file may be used and distributed without restriction
// provided that this copyright statement is not removed from the file
// and that any derivative work contains the original copyright notice
// and the associated disclaimer.
//
// THIS SOURCE FILE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS
// OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Purpose : synthesizable CRC function
//   * polynomial: (0 1 2 4 5 7 8 10 11 12 16 22 23 26 32)
//   * data width: 160
//
// Info : tools@easics.be
//        http://www.easics.com
////////////////////////////////////////////////////////////////////////////////
module CRC32_D104(
    input   [103:0]                           d,
    input   [31:0]                            crc_last,
    output  [31:0]                            crc_out
);
// *************************
// INTERNAL SIGNALS
// *************************

wire    [31:0]                            c;
wire    [31:0]                            newcrc;

// *************************
// CODE
// *************************

  // polynomial: (0 1 2 4 5 7 8 10 11 12 16 22 23 26 32)
  // data width: 8
  // convention: the first serial bit is D[7]

//assign    d = d;
assign    c = crc_last;
assign    crc_out = newcrc;

assign    newcrc[0] = c[0] ^ c[1] ^ c[7] ^ c[9] ^ c[10] ^ c[11] ^ c[12] ^ c[13] ^ c[15] ^ c[22] ^ c[23] ^ c[24] ^ c[25] ^ c[26] ^ c[27] ^ c[29] ^ c[31] ^ d[0] ^ d[6] ^ d[9] ^ d[10] ^ d[12] ^ d[16] ^ d[24] ^ d[25] ^ d[26] ^ d[28] ^ d[29] ^ d[30] ^ d[31] ^ d[32] ^ d[34] ^ d[37] ^ d[44] ^ d[45] ^ d[47] ^ d[48] ^ d[50] ^ d[53] ^ d[54] ^ d[55] ^ d[58] ^ d[60] ^ d[61] ^ d[63] ^ d[65] ^ d[66] ^ d[67] ^ d[68] ^ d[72] ^ d[73] ^ d[79] ^ d[81] ^ d[82] ^ d[83] ^ d[84] ^ d[85] ^ d[87] ^ d[94] ^ d[95] ^ d[96] ^ d[97] ^ d[98] ^ d[99] ^ d[101] ^ d[103];
assign    newcrc[1] = c[0] ^ c[2] ^ c[7] ^ c[8] ^ c[9] ^ c[14] ^ c[15] ^ c[16] ^ c[22] ^ c[28] ^ c[29] ^ c[30] ^ c[31] ^ d[0] ^ d[1] ^ d[6] ^ d[7] ^ d[9] ^ d[11] ^ d[12] ^ d[13] ^ d[16] ^ d[17] ^ d[24] ^ d[27] ^ d[28] ^ d[33] ^ d[34] ^ d[35] ^ d[37] ^ d[38] ^ d[44] ^ d[46] ^ d[47] ^ d[49] ^ d[50] ^ d[51] ^ d[53] ^ d[56] ^ d[58] ^ d[59] ^ d[60] ^ d[62] ^ d[63] ^ d[64] ^ d[65] ^ d[69] ^ d[72] ^ d[74] ^ d[79] ^ d[80] ^ d[81] ^ d[86] ^ d[87] ^ d[88] ^ d[94] ^ d[100] ^ d[101] ^ d[102] ^ d[103];
assign    newcrc[2] = c[0] ^ c[3] ^ c[7] ^ c[8] ^ c[11] ^ c[12] ^ c[13] ^ c[16] ^ c[17] ^ c[22] ^ c[24] ^ c[25] ^ c[26] ^ c[27] ^ c[30] ^ d[0] ^ d[1] ^ d[2] ^ d[6] ^ d[7] ^ d[8] ^ d[9] ^ d[13] ^ d[14] ^ d[16] ^ d[17] ^ d[18] ^ d[24] ^ d[26] ^ d[30] ^ d[31] ^ d[32] ^ d[35] ^ d[36] ^ d[37] ^ d[38] ^ d[39] ^ d[44] ^ d[51] ^ d[52] ^ d[53] ^ d[55] ^ d[57] ^ d[58] ^ d[59] ^ d[64] ^ d[67] ^ d[68] ^ d[70] ^ d[72] ^ d[75] ^ d[79] ^ d[80] ^ d[83] ^ d[84] ^ d[85] ^ d[88] ^ d[89] ^ d[94] ^ d[96] ^ d[97] ^ d[98] ^ d[99] ^ d[102];
assign    newcrc[3] = c[1] ^ c[4] ^ c[8] ^ c[9] ^ c[12] ^ c[13] ^ c[14] ^ c[17] ^ c[18] ^ c[23] ^ c[25] ^ c[26] ^ c[27] ^ c[28] ^ c[31] ^ d[1] ^ d[2] ^ d[3] ^ d[7] ^ d[8] ^ d[9] ^ d[10] ^ d[14] ^ d[15] ^ d[17] ^ d[18] ^ d[19] ^ d[25] ^ d[27] ^ d[31] ^ d[32] ^ d[33] ^ d[36] ^ d[37] ^ d[38] ^ d[39] ^ d[40] ^ d[45] ^ d[52] ^ d[53] ^ d[54] ^ d[56] ^ d[58] ^ d[59] ^ d[60] ^ d[65] ^ d[68] ^ d[69] ^ d[71] ^ d[73] ^ d[76] ^ d[80] ^ d[81] ^ d[84] ^ d[85] ^ d[86] ^ d[89] ^ d[90] ^ d[95] ^ d[97] ^ d[98] ^ d[99] ^ d[100] ^ d[103];
assign    newcrc[4] = c[1] ^ c[2] ^ c[5] ^ c[7] ^ c[11] ^ c[12] ^ c[14] ^ c[18] ^ c[19] ^ c[22] ^ c[23] ^ c[25] ^ c[28] ^ c[31] ^ d[0] ^ d[2] ^ d[3] ^ d[4] ^ d[6] ^ d[8] ^ d[11] ^ d[12] ^ d[15] ^ d[18] ^ d[19] ^ d[20] ^ d[24] ^ d[25] ^ d[29] ^ d[30] ^ d[31] ^ d[33] ^ d[38] ^ d[39] ^ d[40] ^ d[41] ^ d[44] ^ d[45] ^ d[46] ^ d[47] ^ d[48] ^ d[50] ^ d[57] ^ d[58] ^ d[59] ^ d[63] ^ d[65] ^ d[67] ^ d[68] ^ d[69] ^ d[70] ^ d[73] ^ d[74] ^ d[77] ^ d[79] ^ d[83] ^ d[84] ^ d[86] ^ d[90] ^ d[91] ^ d[94] ^ d[95] ^ d[97] ^ d[100] ^ d[103];
assign    newcrc[5] = c[0] ^ c[1] ^ c[2] ^ c[3] ^ c[6] ^ c[7] ^ c[8] ^ c[9] ^ c[10] ^ c[11] ^ c[19] ^ c[20] ^ c[22] ^ c[25] ^ c[27] ^ c[31] ^ d[0] ^ d[1] ^ d[3] ^ d[4] ^ d[5] ^ d[6] ^ d[7] ^ d[10] ^ d[13] ^ d[19] ^ d[20] ^ d[21] ^ d[24] ^ d[28] ^ d[29] ^ d[37] ^ d[39] ^ d[40] ^ d[41] ^ d[42] ^ d[44] ^ d[46] ^ d[49] ^ d[50] ^ d[51] ^ d[53] ^ d[54] ^ d[55] ^ d[59] ^ d[61] ^ d[63] ^ d[64] ^ d[65] ^ d[67] ^ d[69] ^ d[70] ^ d[71] ^ d[72] ^ d[73] ^ d[74] ^ d[75] ^ d[78] ^ d[79] ^ d[80] ^ d[81] ^ d[82] ^ d[83] ^ d[91] ^ d[92] ^ d[94] ^ d[97] ^ d[99] ^ d[103];
assign    newcrc[6] = c[0] ^ c[1] ^ c[2] ^ c[3] ^ c[4] ^ c[7] ^ c[8] ^ c[9] ^ c[10] ^ c[11] ^ c[12] ^ c[20] ^ c[21] ^ c[23] ^ c[26] ^ c[28] ^ d[1] ^ d[2] ^ d[4] ^ d[5] ^ d[6] ^ d[7] ^ d[8] ^ d[11] ^ d[14] ^ d[20] ^ d[21] ^ d[22] ^ d[25] ^ d[29] ^ d[30] ^ d[38] ^ d[40] ^ d[41] ^ d[42] ^ d[43] ^ d[45] ^ d[47] ^ d[50] ^ d[51] ^ d[52] ^ d[54] ^ d[55] ^ d[56] ^ d[60] ^ d[62] ^ d[64] ^ d[65] ^ d[66] ^ d[68] ^ d[70] ^ d[71] ^ d[72] ^ d[73] ^ d[74] ^ d[75] ^ d[76] ^ d[79] ^ d[80] ^ d[81] ^ d[82] ^ d[83] ^ d[84] ^ d[92] ^ d[93] ^ d[95] ^ d[98] ^ d[100];
assign    newcrc[7] = c[2] ^ c[3] ^ c[4] ^ c[5] ^ c[7] ^ c[8] ^ c[15] ^ c[21] ^ c[23] ^ c[25] ^ c[26] ^ c[31] ^ d[0] ^ d[2] ^ d[3] ^ d[5] ^ d[7] ^ d[8] ^ d[10] ^ d[15] ^ d[16] ^ d[21] ^ d[22] ^ d[23] ^ d[24] ^ d[25] ^ d[28] ^ d[29] ^ d[32] ^ d[34] ^ d[37] ^ d[39] ^ d[41] ^ d[42] ^ d[43] ^ d[45] ^ d[46] ^ d[47] ^ d[50] ^ d[51] ^ d[52] ^ d[54] ^ d[56] ^ d[57] ^ d[58] ^ d[60] ^ d[68] ^ d[69] ^ d[71] ^ d[74] ^ d[75] ^ d[76] ^ d[77] ^ d[79] ^ d[80] ^ d[87] ^ d[93] ^ d[95] ^ d[97] ^ d[98] ^ d[103];
assign    newcrc[8] = c[1] ^ c[3] ^ c[4] ^ c[5] ^ c[6] ^ c[7] ^ c[8] ^ c[10] ^ c[11] ^ c[12] ^ c[13] ^ c[15] ^ c[16] ^ c[23] ^ c[25] ^ c[29] ^ c[31] ^ d[0] ^ d[1] ^ d[3] ^ d[4] ^ d[8] ^ d[10] ^ d[11] ^ d[12] ^ d[17] ^ d[22] ^ d[23] ^ d[28] ^ d[31] ^ d[32] ^ d[33] ^ d[34] ^ d[35] ^ d[37] ^ d[38] ^ d[40] ^ d[42] ^ d[43] ^ d[45] ^ d[46] ^ d[50] ^ d[51] ^ d[52] ^ d[54] ^ d[57] ^ d[59] ^ d[60] ^ d[63] ^ d[65] ^ d[66] ^ d[67] ^ d[68] ^ d[69] ^ d[70] ^ d[73] ^ d[75] ^ d[76] ^ d[77] ^ d[78] ^ d[79] ^ d[80] ^ d[82] ^ d[83] ^ d[84] ^ d[85] ^ d[87] ^ d[88] ^ d[95] ^ d[97] ^ d[101] ^ d[103];
assign    newcrc[9] = c[2] ^ c[4] ^ c[5] ^ c[6] ^ c[7] ^ c[8] ^ c[9] ^ c[11] ^ c[12] ^ c[13] ^ c[14] ^ c[16] ^ c[17] ^ c[24] ^ c[26] ^ c[30] ^ d[1] ^ d[2] ^ d[4] ^ d[5] ^ d[9] ^ d[11] ^ d[12] ^ d[13] ^ d[18] ^ d[23] ^ d[24] ^ d[29] ^ d[32] ^ d[33] ^ d[34] ^ d[35] ^ d[36] ^ d[38] ^ d[39] ^ d[41] ^ d[43] ^ d[44] ^ d[46] ^ d[47] ^ d[51] ^ d[52] ^ d[53] ^ d[55] ^ d[58] ^ d[60] ^ d[61] ^ d[64] ^ d[66] ^ d[67] ^ d[68] ^ d[69] ^ d[70] ^ d[71] ^ d[74] ^ d[76] ^ d[77] ^ d[78] ^ d[79] ^ d[80] ^ d[81] ^ d[83] ^ d[84] ^ d[85] ^ d[86] ^ d[88] ^ d[89] ^ d[96] ^ d[98] ^ d[102];
assign    newcrc[10] = c[1] ^ c[3] ^ c[5] ^ c[6] ^ c[8] ^ c[11] ^ c[14] ^ c[17] ^ c[18] ^ c[22] ^ c[23] ^ c[24] ^ c[26] ^ c[29] ^ d[0] ^ d[2] ^ d[3] ^ d[5] ^ d[9] ^ d[13] ^ d[14] ^ d[16] ^ d[19] ^ d[26] ^ d[28] ^ d[29] ^ d[31] ^ d[32] ^ d[33] ^ d[35] ^ d[36] ^ d[39] ^ d[40] ^ d[42] ^ d[50] ^ d[52] ^ d[55] ^ d[56] ^ d[58] ^ d[59] ^ d[60] ^ d[62] ^ d[63] ^ d[66] ^ d[69] ^ d[70] ^ d[71] ^ d[73] ^ d[75] ^ d[77] ^ d[78] ^ d[80] ^ d[83] ^ d[86] ^ d[89] ^ d[90] ^ d[94] ^ d[95] ^ d[96] ^ d[98] ^ d[101];
assign    newcrc[11] = c[1] ^ c[2] ^ c[4] ^ c[6] ^ c[10] ^ c[11] ^ c[13] ^ c[18] ^ c[19] ^ c[22] ^ c[26] ^ c[29] ^ c[30] ^ c[31] ^ d[0] ^ d[1] ^ d[3] ^ d[4] ^ d[9] ^ d[12] ^ d[14] ^ d[15] ^ d[16] ^ d[17] ^ d[20] ^ d[24] ^ d[25] ^ d[26] ^ d[27] ^ d[28] ^ d[31] ^ d[33] ^ d[36] ^ d[40] ^ d[41] ^ d[43] ^ d[44] ^ d[45] ^ d[47] ^ d[48] ^ d[50] ^ d[51] ^ d[54] ^ d[55] ^ d[56] ^ d[57] ^ d[58] ^ d[59] ^ d[64] ^ d[65] ^ d[66] ^ d[68] ^ d[70] ^ d[71] ^ d[73] ^ d[74] ^ d[76] ^ d[78] ^ d[82] ^ d[83] ^ d[85] ^ d[90] ^ d[91] ^ d[94] ^ d[98] ^ d[101] ^ d[102] ^ d[103];
assign    newcrc[12] = c[1] ^ c[2] ^ c[3] ^ c[5] ^ c[9] ^ c[10] ^ c[13] ^ c[14] ^ c[15] ^ c[19] ^ c[20] ^ c[22] ^ c[24] ^ c[25] ^ c[26] ^ c[29] ^ c[30] ^ d[0] ^ d[1] ^ d[2] ^ d[4] ^ d[5] ^ d[6] ^ d[9] ^ d[12] ^ d[13] ^ d[15] ^ d[17] ^ d[18] ^ d[21] ^ d[24] ^ d[27] ^ d[30] ^ d[31] ^ d[41] ^ d[42] ^ d[46] ^ d[47] ^ d[49] ^ d[50] ^ d[51] ^ d[52] ^ d[53] ^ d[54] ^ d[56] ^ d[57] ^ d[59] ^ d[61] ^ d[63] ^ d[68] ^ d[69] ^ d[71] ^ d[73] ^ d[74] ^ d[75] ^ d[77] ^ d[81] ^ d[82] ^ d[85] ^ d[86] ^ d[87] ^ d[91] ^ d[92] ^ d[94] ^ d[96] ^ d[97] ^ d[98] ^ d[101] ^ d[102];
assign    newcrc[13] = c[0] ^ c[2] ^ c[3] ^ c[4] ^ c[6] ^ c[10] ^ c[11] ^ c[14] ^ c[15] ^ c[16] ^ c[20] ^ c[21] ^ c[23] ^ c[25] ^ c[26] ^ c[27] ^ c[30] ^ c[31] ^ d[1] ^ d[2] ^ d[3] ^ d[5] ^ d[6] ^ d[7] ^ d[10] ^ d[13] ^ d[14] ^ d[16] ^ d[18] ^ d[19] ^ d[22] ^ d[25] ^ d[28] ^ d[31] ^ d[32] ^ d[42] ^ d[43] ^ d[47] ^ d[48] ^ d[50] ^ d[51] ^ d[52] ^ d[53] ^ d[54] ^ d[55] ^ d[57] ^ d[58] ^ d[60] ^ d[62] ^ d[64] ^ d[69] ^ d[70] ^ d[72] ^ d[74] ^ d[75] ^ d[76] ^ d[78] ^ d[82] ^ d[83] ^ d[86] ^ d[87] ^ d[88] ^ d[92] ^ d[93] ^ d[95] ^ d[97] ^ d[98] ^ d[99] ^ d[102] ^ d[103];
assign    newcrc[14] = c[1] ^ c[3] ^ c[4] ^ c[5] ^ c[7] ^ c[11] ^ c[12] ^ c[15] ^ c[16] ^ c[17] ^ c[21] ^ c[22] ^ c[24] ^ c[26] ^ c[27] ^ c[28] ^ c[31] ^ d[2] ^ d[3] ^ d[4] ^ d[6] ^ d[7] ^ d[8] ^ d[11] ^ d[14] ^ d[15] ^ d[17] ^ d[19] ^ d[20] ^ d[23] ^ d[26] ^ d[29] ^ d[32] ^ d[33] ^ d[43] ^ d[44] ^ d[48] ^ d[49] ^ d[51] ^ d[52] ^ d[53] ^ d[54] ^ d[55] ^ d[56] ^ d[58] ^ d[59] ^ d[61] ^ d[63] ^ d[65] ^ d[70] ^ d[71] ^ d[73] ^ d[75] ^ d[76] ^ d[77] ^ d[79] ^ d[83] ^ d[84] ^ d[87] ^ d[88] ^ d[89] ^ d[93] ^ d[94] ^ d[96] ^ d[98] ^ d[99] ^ d[100] ^ d[103];
assign    newcrc[15] = c[0] ^ c[2] ^ c[4] ^ c[5] ^ c[6] ^ c[8] ^ c[12] ^ c[13] ^ c[16] ^ c[17] ^ c[18] ^ c[22] ^ c[23] ^ c[25] ^ c[27] ^ c[28] ^ c[29] ^ d[3] ^ d[4] ^ d[5] ^ d[7] ^ d[8] ^ d[9] ^ d[12] ^ d[15] ^ d[16] ^ d[18] ^ d[20] ^ d[21] ^ d[24] ^ d[27] ^ d[30] ^ d[33] ^ d[34] ^ d[44] ^ d[45] ^ d[49] ^ d[50] ^ d[52] ^ d[53] ^ d[54] ^ d[55] ^ d[56] ^ d[57] ^ d[59] ^ d[60] ^ d[62] ^ d[64] ^ d[66] ^ d[71] ^ d[72] ^ d[74] ^ d[76] ^ d[77] ^ d[78] ^ d[80] ^ d[84] ^ d[85] ^ d[88] ^ d[89] ^ d[90] ^ d[94] ^ d[95] ^ d[97] ^ d[99] ^ d[100] ^ d[101];
assign    newcrc[16] = c[3] ^ c[5] ^ c[6] ^ c[10] ^ c[11] ^ c[12] ^ c[14] ^ c[15] ^ c[17] ^ c[18] ^ c[19] ^ c[22] ^ c[25] ^ c[27] ^ c[28] ^ c[30] ^ c[31] ^ d[0] ^ d[4] ^ d[5] ^ d[8] ^ d[12] ^ d[13] ^ d[17] ^ d[19] ^ d[21] ^ d[22] ^ d[24] ^ d[26] ^ d[29] ^ d[30] ^ d[32] ^ d[35] ^ d[37] ^ d[44] ^ d[46] ^ d[47] ^ d[48] ^ d[51] ^ d[56] ^ d[57] ^ d[66] ^ d[68] ^ d[75] ^ d[77] ^ d[78] ^ d[82] ^ d[83] ^ d[84] ^ d[86] ^ d[87] ^ d[89] ^ d[90] ^ d[91] ^ d[94] ^ d[97] ^ d[99] ^ d[100] ^ d[102] ^ d[103];
assign    newcrc[17] = c[4] ^ c[6] ^ c[7] ^ c[11] ^ c[12] ^ c[13] ^ c[15] ^ c[16] ^ c[18] ^ c[19] ^ c[20] ^ c[23] ^ c[26] ^ c[28] ^ c[29] ^ c[31] ^ d[1] ^ d[5] ^ d[6] ^ d[9] ^ d[13] ^ d[14] ^ d[18] ^ d[20] ^ d[22] ^ d[23] ^ d[25] ^ d[27] ^ d[30] ^ d[31] ^ d[33] ^ d[36] ^ d[38] ^ d[45] ^ d[47] ^ d[48] ^ d[49] ^ d[52] ^ d[57] ^ d[58] ^ d[67] ^ d[69] ^ d[76] ^ d[78] ^ d[79] ^ d[83] ^ d[84] ^ d[85] ^ d[87] ^ d[88] ^ d[90] ^ d[91] ^ d[92] ^ d[95] ^ d[98] ^ d[100] ^ d[101] ^ d[103];
assign    newcrc[18] = c[5] ^ c[7] ^ c[8] ^ c[12] ^ c[13] ^ c[14] ^ c[16] ^ c[17] ^ c[19] ^ c[20] ^ c[21] ^ c[24] ^ c[27] ^ c[29] ^ c[30] ^ d[2] ^ d[6] ^ d[7] ^ d[10] ^ d[14] ^ d[15] ^ d[19] ^ d[21] ^ d[23] ^ d[24] ^ d[26] ^ d[28] ^ d[31] ^ d[32] ^ d[34] ^ d[37] ^ d[39] ^ d[46] ^ d[48] ^ d[49] ^ d[50] ^ d[53] ^ d[58] ^ d[59] ^ d[68] ^ d[70] ^ d[77] ^ d[79] ^ d[80] ^ d[84] ^ d[85] ^ d[86] ^ d[88] ^ d[89] ^ d[91] ^ d[92] ^ d[93] ^ d[96] ^ d[99] ^ d[101] ^ d[102];
assign    newcrc[19] = c[6] ^ c[8] ^ c[9] ^ c[13] ^ c[14] ^ c[15] ^ c[17] ^ c[18] ^ c[20] ^ c[21] ^ c[22] ^ c[25] ^ c[28] ^ c[30] ^ c[31] ^ d[3] ^ d[7] ^ d[8] ^ d[11] ^ d[15] ^ d[16] ^ d[20] ^ d[22] ^ d[24] ^ d[25] ^ d[27] ^ d[29] ^ d[32] ^ d[33] ^ d[35] ^ d[38] ^ d[40] ^ d[47] ^ d[49] ^ d[50] ^ d[51] ^ d[54] ^ d[59] ^ d[60] ^ d[69] ^ d[71] ^ d[78] ^ d[80] ^ d[81] ^ d[85] ^ d[86] ^ d[87] ^ d[89] ^ d[90] ^ d[92] ^ d[93] ^ d[94] ^ d[97] ^ d[100] ^ d[102] ^ d[103];
assign    newcrc[20] = c[0] ^ c[7] ^ c[9] ^ c[10] ^ c[14] ^ c[15] ^ c[16] ^ c[18] ^ c[19] ^ c[21] ^ c[22] ^ c[23] ^ c[26] ^ c[29] ^ c[31] ^ d[4] ^ d[8] ^ d[9] ^ d[12] ^ d[16] ^ d[17] ^ d[21] ^ d[23] ^ d[25] ^ d[26] ^ d[28] ^ d[30] ^ d[33] ^ d[34] ^ d[36] ^ d[39] ^ d[41] ^ d[48] ^ d[50] ^ d[51] ^ d[52] ^ d[55] ^ d[60] ^ d[61] ^ d[70] ^ d[72] ^ d[79] ^ d[81] ^ d[82] ^ d[86] ^ d[87] ^ d[88] ^ d[90] ^ d[91] ^ d[93] ^ d[94] ^ d[95] ^ d[98] ^ d[101] ^ d[103];
assign    newcrc[21] = c[1] ^ c[8] ^ c[10] ^ c[11] ^ c[15] ^ c[16] ^ c[17] ^ c[19] ^ c[20] ^ c[22] ^ c[23] ^ c[24] ^ c[27] ^ c[30] ^ d[5] ^ d[9] ^ d[10] ^ d[13] ^ d[17] ^ d[18] ^ d[22] ^ d[24] ^ d[26] ^ d[27] ^ d[29] ^ d[31] ^ d[34] ^ d[35] ^ d[37] ^ d[40] ^ d[42] ^ d[49] ^ d[51] ^ d[52] ^ d[53] ^ d[56] ^ d[61] ^ d[62] ^ d[71] ^ d[73] ^ d[80] ^ d[82] ^ d[83] ^ d[87] ^ d[88] ^ d[89] ^ d[91] ^ d[92] ^ d[94] ^ d[95] ^ d[96] ^ d[99] ^ d[102];
assign    newcrc[22] = c[1] ^ c[2] ^ c[7] ^ c[10] ^ c[13] ^ c[15] ^ c[16] ^ c[17] ^ c[18] ^ c[20] ^ c[21] ^ c[22] ^ c[26] ^ c[27] ^ c[28] ^ c[29] ^ d[0] ^ d[9] ^ d[11] ^ d[12] ^ d[14] ^ d[16] ^ d[18] ^ d[19] ^ d[23] ^ d[24] ^ d[26] ^ d[27] ^ d[29] ^ d[31] ^ d[34] ^ d[35] ^ d[36] ^ d[37] ^ d[38] ^ d[41] ^ d[43] ^ d[44] ^ d[45] ^ d[47] ^ d[48] ^ d[52] ^ d[55] ^ d[57] ^ d[58] ^ d[60] ^ d[61] ^ d[62] ^ d[65] ^ d[66] ^ d[67] ^ d[68] ^ d[73] ^ d[74] ^ d[79] ^ d[82] ^ d[85] ^ d[87] ^ d[88] ^ d[89] ^ d[90] ^ d[92] ^ d[93] ^ d[94] ^ d[98] ^ d[99] ^ d[100] ^ d[101];
assign    newcrc[23] = c[0] ^ c[1] ^ c[2] ^ c[3] ^ c[7] ^ c[8] ^ c[9] ^ c[10] ^ c[12] ^ c[13] ^ c[14] ^ c[15] ^ c[16] ^ c[17] ^ c[18] ^ c[19] ^ c[21] ^ c[24] ^ c[25] ^ c[26] ^ c[28] ^ c[30] ^ c[31] ^ d[0] ^ d[1] ^ d[6] ^ d[9] ^ d[13] ^ d[15] ^ d[16] ^ d[17] ^ d[19] ^ d[20] ^ d[26] ^ d[27] ^ d[29] ^ d[31] ^ d[34] ^ d[35] ^ d[36] ^ d[38] ^ d[39] ^ d[42] ^ d[46] ^ d[47] ^ d[49] ^ d[50] ^ d[54] ^ d[55] ^ d[56] ^ d[59] ^ d[60] ^ d[62] ^ d[65] ^ d[69] ^ d[72] ^ d[73] ^ d[74] ^ d[75] ^ d[79] ^ d[80] ^ d[81] ^ d[82] ^ d[84] ^ d[85] ^ d[86] ^ d[87] ^ d[88] ^ d[89] ^ d[90] ^ d[91] ^ d[93] ^ d[96] ^ d[97] ^ d[98] ^ d[100] ^ d[102] ^ d[103];
assign    newcrc[24] = c[1] ^ c[2] ^ c[3] ^ c[4] ^ c[8] ^ c[9] ^ c[10] ^ c[11] ^ c[13] ^ c[14] ^ c[15] ^ c[16] ^ c[17] ^ c[18] ^ c[19] ^ c[20] ^ c[22] ^ c[25] ^ c[26] ^ c[27] ^ c[29] ^ c[31] ^ d[1] ^ d[2] ^ d[7] ^ d[10] ^ d[14] ^ d[16] ^ d[17] ^ d[18] ^ d[20] ^ d[21] ^ d[27] ^ d[28] ^ d[30] ^ d[32] ^ d[35] ^ d[36] ^ d[37] ^ d[39] ^ d[40] ^ d[43] ^ d[47] ^ d[48] ^ d[50] ^ d[51] ^ d[55] ^ d[56] ^ d[57] ^ d[60] ^ d[61] ^ d[63] ^ d[66] ^ d[70] ^ d[73] ^ d[74] ^ d[75] ^ d[76] ^ d[80] ^ d[81] ^ d[82] ^ d[83] ^ d[85] ^ d[86] ^ d[87] ^ d[88] ^ d[89] ^ d[90] ^ d[91] ^ d[92] ^ d[94] ^ d[97] ^ d[98] ^ d[99] ^ d[101] ^ d[103];
assign    newcrc[25] = c[2] ^ c[3] ^ c[4] ^ c[5] ^ c[9] ^ c[10] ^ c[11] ^ c[12] ^ c[14] ^ c[15] ^ c[16] ^ c[17] ^ c[18] ^ c[19] ^ c[20] ^ c[21] ^ c[23] ^ c[26] ^ c[27] ^ c[28] ^ c[30] ^ d[2] ^ d[3] ^ d[8] ^ d[11] ^ d[15] ^ d[17] ^ d[18] ^ d[19] ^ d[21] ^ d[22] ^ d[28] ^ d[29] ^ d[31] ^ d[33] ^ d[36] ^ d[37] ^ d[38] ^ d[40] ^ d[41] ^ d[44] ^ d[48] ^ d[49] ^ d[51] ^ d[52] ^ d[56] ^ d[57] ^ d[58] ^ d[61] ^ d[62] ^ d[64] ^ d[67] ^ d[71] ^ d[74] ^ d[75] ^ d[76] ^ d[77] ^ d[81] ^ d[82] ^ d[83] ^ d[84] ^ d[86] ^ d[87] ^ d[88] ^ d[89] ^ d[90] ^ d[91] ^ d[92] ^ d[93] ^ d[95] ^ d[98] ^ d[99] ^ d[100] ^ d[102];
assign    newcrc[26] = c[1] ^ c[3] ^ c[4] ^ c[5] ^ c[6] ^ c[7] ^ c[9] ^ c[16] ^ c[17] ^ c[18] ^ c[19] ^ c[20] ^ c[21] ^ c[23] ^ c[25] ^ c[26] ^ c[28] ^ d[0] ^ d[3] ^ d[4] ^ d[6] ^ d[10] ^ d[18] ^ d[19] ^ d[20] ^ d[22] ^ d[23] ^ d[24] ^ d[25] ^ d[26] ^ d[28] ^ d[31] ^ d[38] ^ d[39] ^ d[41] ^ d[42] ^ d[44] ^ d[47] ^ d[48] ^ d[49] ^ d[52] ^ d[54] ^ d[55] ^ d[57] ^ d[59] ^ d[60] ^ d[61] ^ d[62] ^ d[66] ^ d[67] ^ d[73] ^ d[75] ^ d[76] ^ d[77] ^ d[78] ^ d[79] ^ d[81] ^ d[88] ^ d[89] ^ d[90] ^ d[91] ^ d[92] ^ d[93] ^ d[95] ^ d[97] ^ d[98] ^ d[100];
assign    newcrc[27] = c[2] ^ c[4] ^ c[5] ^ c[6] ^ c[7] ^ c[8] ^ c[10] ^ c[17] ^ c[18] ^ c[19] ^ c[20] ^ c[21] ^ c[22] ^ c[24] ^ c[26] ^ c[27] ^ c[29] ^ d[1] ^ d[4] ^ d[5] ^ d[7] ^ d[11] ^ d[19] ^ d[20] ^ d[21] ^ d[23] ^ d[24] ^ d[25] ^ d[26] ^ d[27] ^ d[29] ^ d[32] ^ d[39] ^ d[40] ^ d[42] ^ d[43] ^ d[45] ^ d[48] ^ d[49] ^ d[50] ^ d[53] ^ d[55] ^ d[56] ^ d[58] ^ d[60] ^ d[61] ^ d[62] ^ d[63] ^ d[67] ^ d[68] ^ d[74] ^ d[76] ^ d[77] ^ d[78] ^ d[79] ^ d[80] ^ d[82] ^ d[89] ^ d[90] ^ d[91] ^ d[92] ^ d[93] ^ d[94] ^ d[96] ^ d[98] ^ d[99] ^ d[101];
assign    newcrc[28] = c[3] ^ c[5] ^ c[6] ^ c[7] ^ c[8] ^ c[9] ^ c[11] ^ c[18] ^ c[19] ^ c[20] ^ c[21] ^ c[22] ^ c[23] ^ c[25] ^ c[27] ^ c[28] ^ c[30] ^ d[2] ^ d[5] ^ d[6] ^ d[8] ^ d[12] ^ d[20] ^ d[21] ^ d[22] ^ d[24] ^ d[25] ^ d[26] ^ d[27] ^ d[28] ^ d[30] ^ d[33] ^ d[40] ^ d[41] ^ d[43] ^ d[44] ^ d[46] ^ d[49] ^ d[50] ^ d[51] ^ d[54] ^ d[56] ^ d[57] ^ d[59] ^ d[61] ^ d[62] ^ d[63] ^ d[64] ^ d[68] ^ d[69] ^ d[75] ^ d[77] ^ d[78] ^ d[79] ^ d[80] ^ d[81] ^ d[83] ^ d[90] ^ d[91] ^ d[92] ^ d[93] ^ d[94] ^ d[95] ^ d[97] ^ d[99] ^ d[100] ^ d[102];
assign    newcrc[29] = c[4] ^ c[6] ^ c[7] ^ c[8] ^ c[9] ^ c[10] ^ c[12] ^ c[19] ^ c[20] ^ c[21] ^ c[22] ^ c[23] ^ c[24] ^ c[26] ^ c[28] ^ c[29] ^ c[31] ^ d[3] ^ d[6] ^ d[7] ^ d[9] ^ d[13] ^ d[21] ^ d[22] ^ d[23] ^ d[25] ^ d[26] ^ d[27] ^ d[28] ^ d[29] ^ d[31] ^ d[34] ^ d[41] ^ d[42] ^ d[44] ^ d[45] ^ d[47] ^ d[50] ^ d[51] ^ d[52] ^ d[55] ^ d[57] ^ d[58] ^ d[60] ^ d[62] ^ d[63] ^ d[64] ^ d[65] ^ d[69] ^ d[70] ^ d[76] ^ d[78] ^ d[79] ^ d[80] ^ d[81] ^ d[82] ^ d[84] ^ d[91] ^ d[92] ^ d[93] ^ d[94] ^ d[95] ^ d[96] ^ d[98] ^ d[100] ^ d[101] ^ d[103];
assign    newcrc[30] = c[5] ^ c[7] ^ c[8] ^ c[9] ^ c[10] ^ c[11] ^ c[13] ^ c[20] ^ c[21] ^ c[22] ^ c[23] ^ c[24] ^ c[25] ^ c[27] ^ c[29] ^ c[30] ^ d[4] ^ d[7] ^ d[8] ^ d[10] ^ d[14] ^ d[22] ^ d[23] ^ d[24] ^ d[26] ^ d[27] ^ d[28] ^ d[29] ^ d[30] ^ d[32] ^ d[35] ^ d[42] ^ d[43] ^ d[45] ^ d[46] ^ d[48] ^ d[51] ^ d[52] ^ d[53] ^ d[56] ^ d[58] ^ d[59] ^ d[61] ^ d[63] ^ d[64] ^ d[65] ^ d[66] ^ d[70] ^ d[71] ^ d[77] ^ d[79] ^ d[80] ^ d[81] ^ d[82] ^ d[83] ^ d[85] ^ d[92] ^ d[93] ^ d[94] ^ d[95] ^ d[96] ^ d[97] ^ d[99] ^ d[101] ^ d[102];
assign    newcrc[31] = c[0] ^ c[6] ^ c[8] ^ c[9] ^ c[10] ^ c[11] ^ c[12] ^ c[14] ^ c[21] ^ c[22] ^ c[23] ^ c[24] ^ c[25] ^ c[26] ^ c[28] ^ c[30] ^ c[31] ^ d[5] ^ d[8] ^ d[9] ^ d[11] ^ d[15] ^ d[23] ^ d[24] ^ d[25] ^ d[27] ^ d[28] ^ d[29] ^ d[30] ^ d[31] ^ d[33] ^ d[36] ^ d[43] ^ d[44] ^ d[46] ^ d[47] ^ d[49] ^ d[52] ^ d[53] ^ d[54] ^ d[57] ^ d[59] ^ d[60] ^ d[62] ^ d[64] ^ d[65] ^ d[66] ^ d[67] ^ d[71] ^ d[72] ^ d[78] ^ d[80] ^ d[81] ^ d[82] ^ d[83] ^ d[84] ^ d[86] ^ d[93] ^ d[94] ^ d[95] ^ d[96] ^ d[97] ^ d[98] ^ d[100] ^ d[102] ^ d[103];


endmodule
