/* 

The insert op module of PBSketch

*/


module Insert_Layer (
    input                                                   clk,
    input                                                   rst_n,

    input   [1:0]                                           i_time_step,

    input   [9:0]                                           i_addr_0,
    input   [2:0]                                           i_key_0,
    input                                                   i_addr_0_v,
    input   [9:0]                                           i_addr_1,
    input   [2:0]                                           i_key_1,
    input                                                   i_addr_1_v,

    output  reg [9:0]                                       o_addr_0,
    output  reg [2:0]                                       o_key_0,
    output  reg                                             o_hot_0_v,
    output  reg [4:0]                                       o_freq_0,

    output  reg [9:0]                                       o_addr_1,
    output  reg [2:0]                                       o_key_1,
    output  reg                                             o_hot_1_v,
    output  reg [4:0]                                       o_freq_1,


    output  [1:0]                                           o_time_step
);


assign      o_time_step                         =           time_step_r2;


parameter   Thrh                                =           'd10;





// cold memory imp
reg         [35:0]                                          rdata_cold_mem_0;
reg         [35:0]                                          rdata_cold_mem_1;
wire        [35:0]                                          rdata_cold_mem_0_w;
wire        [35:0]                                          rdata_cold_mem_1_w;

always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        rdata_cold_mem_0                        <=          36'b0;
        rdata_cold_mem_1                        <=          36'b0;
    end
    else begin
        rdata_cold_mem_0                        <=          rdata_cold_mem_0_w;
        rdata_cold_mem_1                        <=          rdata_cold_mem_1_w;
    end
end


Cold_Mem    cold_mem_0(
    // wr ports
    .addra                              (i_addr_0_r2),
    .clka                               (clk),
    .dina                               (wdata_cold_mem_0),
    .wea                                (wea_cold_mem_0),
    // rd ports
    .addrb                              (i_addr_0),
    .clkb                               (clk),
    .doutb                              (rdata_cold_mem_0_w)
);


Cold_Mem    cold_mem_1(
    // wr ports
    .addra                              (i_addr_1_r2),
    .clka                               (clk),
    .dina                               (wdata_cold_mem_1),
    .wea                                (wea_cold_mem_1),
    // rd ports
    .addrb                              (i_addr_1),
    .clkb                               (clk),
    .doutb                              (rdata_cold_mem_1_w)
);


wire        [2:0]                       key_0_a_w;
wire        [2:0]                       key_0_b_w;
wire        [2:0]                       key_0_c_w;
wire        [2:0]                       key_0_d_w;
assign      key_0_a_w           =       rdata_cold_mem_0[35:33];
assign      key_0_b_w           =       rdata_cold_mem_0[26:24];
assign      key_0_c_w           =       rdata_cold_mem_0[17:15];
assign      key_0_d_w           =       rdata_cold_mem_0[8:6];

wire        [4:0]                       freq_0_a_w;
wire        [4:0]                       freq_0_b_w;
wire        [4:0]                       freq_0_c_w;
wire        [4:0]                       freq_0_d_w;
assign      freq_0_a_w          =       rdata_cold_mem_0[32:28];
assign      freq_0_b_w          =       rdata_cold_mem_0[23:19];
assign      freq_0_c_w          =       rdata_cold_mem_0[14:10];
assign      freq_0_d_w          =       rdata_cold_mem_0[5:1];

wire                                    occupied_0_a_w;
wire                                    occupied_0_b_w;
wire                                    occupied_0_c_w;
wire                                    occupied_0_d_w;
assign      occupied_0_a_w      =       rdata_cold_mem_1[27];
assign      occupied_0_b_w      =       rdata_cold_mem_1[18];
assign      occupied_0_c_w      =       rdata_cold_mem_1[9];
assign      occupied_0_d_w      =       rdata_cold_mem_1[0];

wire        [2:0]                       key_1_a_w;
wire        [2:0]                       key_1_b_w;
wire        [2:0]                       key_1_c_w;
wire        [2:0]                       key_1_d_w;
assign      key_1_a_w           =       rdata_cold_mem_1[35:33];
assign      key_1_b_w           =       rdata_cold_mem_1[26:24];
assign      key_1_c_w           =       rdata_cold_mem_1[17:15];
assign      key_1_d_w           =       rdata_cold_mem_1[8:6];

wire        [4:0]                       freq_1_a_w;
wire        [4:0]                       freq_1_b_w;
wire        [4:0]                       freq_1_c_w;
wire        [4:0]                       freq_1_d_w;
assign      freq_1_a_w          =       rdata_cold_mem_1[32:28];
assign      freq_1_b_w          =       rdata_cold_mem_1[23:19];
assign      freq_1_c_w          =       rdata_cold_mem_1[14:10];
assign      freq_1_d_w          =       rdata_cold_mem_1[5:1];

wire                                    occupied_1_a_w;
wire                                    occupied_1_b_w;
wire                                    occupied_1_c_w;
wire                                    occupied_1_d_w;
assign      occupied_1_a_w      =       rdata_cold_mem_1[27];
assign      occupied_1_b_w      =       rdata_cold_mem_1[18];
assign      occupied_1_c_w      =       rdata_cold_mem_1[9];
assign      occupied_1_d_w      =       rdata_cold_mem_1[0];






// wr cold ram imp
reg         [35:0]                                          wdata_cold_mem_0;
reg         [35:0]                                          wdata_cold_mem_1;
reg                                                         wea_cold_mem_0;
reg                                                         wea_cold_mem_1;

always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        wdata_cold_mem_0                            <=      36'd0;
        wdata_cold_mem_1                            <=      36'd0;
        wea_cold_mem_0                              <=      1'b0;
        wea_cold_mem_1                              <=      1'b0;
        wea_ts_mem_0                                <=      1'b0;
        wea_ts_mem_1                                <=      1'b0;
        wdata_ts_mem_0                              <=      8'd0;
        wdata_ts_mem_1                              <=      8'd0;

        o_hot_0_v                                   <=      1'b0;
        o_hot_1_v                                   <=      1'b0;
    end
    else begin
        if (i_addr_0_v_r1) begin
            // both RAM not hit
            if ((key_0_a_w != i_key_0_r1) && (key_0_b_w != i_key_0_r1) && (key_0_c_w != i_key_0_r1) && (key_0_d_w != i_key_0_r1)
                && (key_1_a_w != i_key_1_r1) && (key_1_b_w != i_key_1_r1) && (key_1_c_w != i_key_1_r1 && (key_1_d_w != i_key_1_r1))) begin
                // slot 1 is available
                if(occupied_0_a_w == 1'b0) begin
                    wdata_cold_mem_0                <=      {i_key_0_r1, 5'b1, 1'b1, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                    wdata_ts_mem_0                  <=      {time_step_r1, ts_0_b_w, ts_0_c_w, ts_0_d_w};
                    wea_cold_mem_0                  <=      1'b1;
                    wea_cold_mem_1                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b1;
                    wea_ts_mem_1                    <=      1'b0;
                end
                else if (occupied_0_b_w == 1'b0) begin
                    wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, i_key_0_r1, 5'b1, 1'b1, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                    wdata_ts_mem_0                  <=      {ts_0_a_w, time_step_r1, ts_0_c_w, ts_0_d_w};
                    wea_cold_mem_0                  <=      1'b1;
                    wea_cold_mem_1                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b1;
                    wea_ts_mem_1                    <=      1'b0;
                end
                else if (occupied_0_c_w == 1'b0) begin
                    wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, i_key_0_r1, 5'b1, 1'b1, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                    wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, time_step_r1, ts_0_d_w};
                    wea_cold_mem_0                  <=      1'b1;
                    wea_cold_mem_1                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b1;
                    wea_ts_mem_1                    <=      1'b0;
                end
                else if (occupied_0_d_w == 1'b0) begin
                    wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, i_key_0_r1, 5'b1, 1'b1};
                    wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, time_step_r1};
                    wea_cold_mem_0                  <=      1'b1;
                    wea_cold_mem_1                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b1;
                    wea_ts_mem_1                    <=      1'b0;
                end
                else if(occupied_1_a_w == 1'b0) begin
                    wdata_cold_mem_1                <=      {i_key_1_r1, 5'b1, 1'b1, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                    wdata_ts_mem_1                  <=      {time_step_r1, ts_1_b_w, ts_1_c_w, ts_1_d_w};
                    wea_cold_mem_1                  <=      1'b1;
                    wea_cold_mem_0                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b0;
                    wea_ts_mem_1                    <=      1'b1;
                end
                else if (occupied_1_b_w == 1'b0) begin
                    wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, i_key_1_r1, 5'b1, 1'b1, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                    wdata_ts_mem_1                  <=      {ts_1_a_w, time_step_r1, ts_1_c_w, ts_1_d_w};
                    wea_cold_mem_1                  <=      1'b1;
                    wea_cold_mem_0                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b0;
                    wea_ts_mem_1                    <=      1'b1;

                end
                else if (occupied_1_c_w == 1'b0) begin
                    wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, i_key_1_r1, 5'b1, 1'b1, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                    wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, time_step_r1, ts_1_d_w};
                    wea_cold_mem_1                  <=      1'b1;
                    wea_cold_mem_0                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b0;
                    wea_ts_mem_1                    <=      1'b1;

                end
                else if (occupied_1_d_w == 1'b0) begin
                    wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, i_key_1_r1, 5'b1, 1'b1};
                    wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, time_step_r1};
                    wea_cold_mem_1                  <=      1'b1;
                    wea_cold_mem_0                  <=      1'b0;
                    wea_ts_mem_0                    <=      1'b0;
                    wea_ts_mem_1                    <=      1'b1;
                end

            end

            // RAM 1 hit, update and check later
            else if ((key_0_a_w == i_key_0_r1) || (key_0_b_w == i_key_0_r1) || (key_0_c_w == i_key_0_r1) || (key_0_d_w == i_key_0_r1)) begin
                wea_cold_mem_0                      <=      1'b1;
                wea_cold_mem_1                      <=      1'b0;
                wea_ts_mem_0                        <=      1'b1;
                wea_ts_mem_1                        <=      1'b0;

                if (key_0_a_w == i_key_0_r1) begin
                    // check if in current wind
                    if (time_step_r1 == ts_0_a_w) begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w+5'b1, 1'b1, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, ts_0_d_w};
                        
                        // judging hot data
                        if (freq_0_a_w+5'b1 >= Thrh) begin
                            o_hot_0_v                   <=      1'b1;
                            o_hot_1_v                   <=      1'b0;
                            o_freq_0                    <=      freq_0_a_w+5'b1;
                            o_addr_0                    <=      i_addr_0_r1;
                            o_key_0                     <=      i_key_0_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    // if a new wind
                    else begin
                        wdata_cold_mem_0                <=      {key_0_a_w,5'b1, 1'b1, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {time_step_r1, ts_0_b_w, ts_0_c_w, ts_0_d_w};
                    end
                end

                else if (key_0_b_w == i_key_0_r1) begin
                    // check if in current wind
                    if (time_step_r1 == ts_0_b_w) begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w+5'b1, 1'b1, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, ts_0_d_w};

                        // judging hot data
                        if (freq_0_b_w+5'b1 >= Thrh) begin
                            o_hot_0_v                   <=      1'b1;
                            o_hot_1_v                   <=      1'b0;
                            o_freq_0                    <=      freq_0_b_w+5'b1;
                            o_addr_0                    <=      i_addr_0_r1;
                            o_key_0                     <=      i_key_0_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, 5'b1, 1'b1, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, time_step_r1, ts_0_c_w, ts_0_d_w};
                    end
                end

                else if (key_0_c_w == i_key_0_r1) begin
                    // check if in current wind
                    if (time_step_r1 == ts_0_c_w) begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w+5'b1, 1'b1, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, ts_0_d_w};

                        // judging hot data
                        if (freq_0_c_w+5'b1 >= Thrh) begin
                            o_hot_0_v                   <=      1'b1;
                            o_hot_1_v                   <=      1'b0;
                            o_freq_0                    <=      freq_0_c_w+5'b1;
                            o_addr_0                    <=      i_addr_0_r1;
                            o_key_0                     <=      i_key_0_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, 5'b1, 1'b1, key_0_d_w, freq_0_d_w, occupied_0_d_w};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, time_step_r1, ts_0_d_w};
                    end
                end
                else if (key_0_d_w == i_key_0_r1) begin
                    // check if in current wind
                    if (time_step_r1 == ts_0_d_w) begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, freq_0_d_w+5'b1, 1'b1};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, ts_0_d_w};

                        // judging hot data
                        if (freq_0_d_w+5'b1 >= Thrh) begin
                            o_hot_0_v                   <=      1'b1;
                            o_hot_1_v                   <=      1'b0;
                            o_freq_0                    <=      freq_0_d_w+5'b1;
                            o_addr_0                    <=      i_addr_0_r1;
                            o_key_0                     <=      i_key_0_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_0                <=      {key_0_a_w, freq_0_a_w, occupied_0_a_w, key_0_b_w, freq_0_b_w, occupied_0_b_w, key_0_c_w, freq_0_c_w, occupied_0_c_w, key_0_d_w, 5'b1, 1'b1};
                        wdata_ts_mem_0                  <=      {ts_0_a_w, ts_0_b_w, ts_0_c_w, time_step_r1};
                    end
                end
                else begin

                end
            end

            // RAM 2 hit, update and check later
            else if ((key_1_a_w == i_key_1_r1) || (key_1_b_w == i_key_1_r1) || (key_1_c_w == i_key_1_r1) || (key_1_d_w == i_key_1_r1)) begin
                wea_cold_mem_1                      <=      1'b1;
                wea_cold_mem_0                      <=      1'b0;
                wea_ts_mem_0                        <=      1'b0;
                wea_ts_mem_1                        <=      1'b1;

                if (key_1_a_w == i_key_1_r1) begin
                    if (time_step_r1 == ts_1_a_w) begin
                        wdata_cold_mem_1                <=      {key_1_a_w,freq_1_a_w+5'b1, 1'b1, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, ts_1_d_w};
                    
                        // judging hot data
                        if (freq_1_a_w+5'b1 >= Thrh) begin
                            o_hot_1_v                   <=      1'b1;
                            o_hot_0_v                   <=      1'b0;
                            o_freq_1                    <=      freq_1_a_w+5'b1;
                            o_addr_1                    <=      i_addr_1_r1;
                            o_key_1                     <=      i_key_1_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_1                <=      {key_1_a_w, 5'b1, 1'b1, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {time_step_r1, ts_1_b_w, ts_1_c_w, ts_1_d_w};
                    end
                end

                else if (key_1_b_w == i_key_1_r1) begin
                    if (time_step_r1 == ts_1_b_w) begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w+5'b1, 1'b1, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, ts_1_d_w};

                        // judging hot data
                        if (freq_1_b_w+5'b1 >= Thrh) begin
                            o_hot_1_v                   <=      1'b1;
                            o_hot_0_v                   <=      1'b0;
                            o_freq_1                    <=      freq_1_b_w+5'b1;
                            o_addr_1                    <=      i_addr_1_r1;
                            o_key_1                     <=      i_key_1_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, 5'b1, 1'b1, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, time_step_r1, ts_1_c_w, ts_1_d_w};
                    end
                end
                
                else if (key_1_c_w == i_key_1_r1) begin
                    if (time_step_r1 == ts_1_c_w) begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w+5'b1, 1'b1, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, ts_1_d_w};

                        // judging hot data
                        if (freq_1_c_w+5'b1 >= Thrh) begin
                            o_hot_1_v                   <=      1'b1;
                            o_hot_0_v                   <=      1'b0;
                            o_freq_1                    <=      freq_1_c_w+5'b1;
                            o_addr_1                    <=      i_addr_1_r1;
                            o_key_1                     <=      i_key_1_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, 5'b1, 1'b1, key_1_d_w, freq_1_d_w, occupied_1_d_w};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, time_step_r1, ts_1_d_w};
                    end
                end
                
                else if (key_1_d_w == i_key_1_r1) begin
                    if (time_step_r1 == ts_1_d_w) begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, freq_1_d_w+5'b1, 1'b1};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, ts_1_d_w};

                        // judging hot data
                        if (freq_1_d_w+5'b1 >= Thrh) begin
                            o_hot_1_v                   <=      1'b1;
                            o_hot_0_v                   <=      1'b0;
                            o_freq_1                    <=      freq_1_d_w+5'b1;
                            o_addr_1                    <=      i_addr_1_r1;
                            o_key_1                     <=      i_key_1_r1;
                        end
                        else begin
                            o_hot_0_v                   <=      1'b0;
                            o_hot_1_v                   <=      1'b0;
                        end
                    end
                    else begin
                        wdata_cold_mem_1                <=      {key_1_a_w, freq_1_a_w, occupied_1_a_w, key_1_b_w, freq_1_b_w, occupied_1_b_w, key_1_c_w, freq_1_c_w, occupied_1_c_w, key_1_d_w, 5'b1, 1'b1};
                        wdata_ts_mem_1                  <=      {ts_1_a_w, ts_1_b_w, ts_1_c_w, time_step_r1};
                    end
                end
            end
        end

        else begin
            wea_cold_mem_0                          <=      1'b0;
            wea_cold_mem_1                          <=      1'b0;
            wea_ts_mem_0                            <=      1'b0;
            wea_ts_mem_1                            <=      1'b0;
        end
    end
end




// time step RAM
reg         [7:0]                                           rdata_ts_mem_0;
reg         [7:0]                                           rdata_ts_mem_1;
wire        [7:0]                                           rdata_ts_0_w;
wire        [7:0]                                           rdata_ts_1_w;

reg         [7:0]                                           wdata_ts_mem_0;
reg         [7:0]                                           wdata_ts_mem_1;
reg                                                         wea_ts_mem_0;
reg                                                         wea_ts_mem_1;

always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        rdata_ts_mem_0                          <=          8'b0;
        rdata_ts_mem_1                          <=          8'b0;
    end
    else begin
        rdata_ts_mem_0                          <=          rdata_ts_0_w;
        rdata_ts_mem_1                          <=          rdata_ts_1_w;
    end
end


Cold_Mem_Timeline    ts_mem_0(
    // wr ports
    .addra                              (i_addr_0_r2),
    .clka                               (clk),
    .dina                               (wdata_ts_mem_0),
    .wea                                (wea_ts_mem_0),
    // rd ports
    .addrb                              (i_addr_0),
    .clkb                               (clk),
    .doutb                              (rdata_ts_0_w)
);


Cold_Mem_Timeline    ts_mem_1(
    // wr ports
    .addra                              (i_addr_1_r2),
    .clka                               (clk),
    .dina                               (wdata_ts_mem_1),
    .wea                                (wea_ts_mem_1),
    // rd ports
    .addrb                              (i_addr_1),
    .clkb                               (clk),
    .doutb                              (rdata_ts_1_w)
);


wire        [1:0]                       ts_0_a_w;
wire        [1:0]                       ts_0_b_w;
wire        [1:0]                       ts_0_c_w;
wire        [1:0]                       ts_0_d_w;
assign      ts_0_a_w           =        rdata_ts_mem_0[7:6];
assign      ts_0_b_w           =        rdata_ts_mem_0[5:4];
assign      ts_0_c_w           =        rdata_ts_mem_0[3:2];
assign      ts_0_d_w           =        rdata_ts_mem_0[1:0];


wire        [1:0]                       ts_1_a_w;
wire        [1:0]                       ts_1_b_w;
wire        [1:0]                       ts_1_c_w;
wire        [1:0]                       ts_1_d_w;
assign      ts_1_a_w           =        rdata_ts_mem_1[7:6];
assign      ts_1_b_w           =        rdata_ts_mem_1[5:4];
assign      ts_1_c_w           =        rdata_ts_mem_1[3:2];
assign      ts_1_d_w           =        rdata_ts_mem_1[1:0];
















// caching pipe
reg         [9:0]                                           i_addr_0_r0;
reg         [9:0]                                           i_addr_0_r1;
reg         [9:0]                                           i_addr_0_r2;
reg         [9:0]                                           i_addr_0_r3;
reg         [9:0]                                           i_addr_0_r4;
reg         [9:0]                                           i_addr_0_r5;
reg         [9:0]                                           i_key_0_r0;
reg         [9:0]                                           i_key_0_r1;
reg         [9:0]                                           i_key_0_r2;
reg         [9:0]                                           i_key_0_r3;
reg         [9:0]                                           i_key_0_r4;
reg         [9:0]                                           i_key_0_r5;
reg         [9:0]                                           i_addr_1_r0;
reg         [9:0]                                           i_addr_1_r1;
reg         [9:0]                                           i_addr_1_r2;
reg         [9:0]                                           i_addr_1_r3;
reg         [9:0]                                           i_addr_1_r4;
reg         [9:0]                                           i_addr_1_r5;
reg         [9:0]                                           i_key_1_r0;
reg         [9:0]                                           i_key_1_r1;
reg         [9:0]                                           i_key_1_r2;
reg         [9:0]                                           i_key_1_r3;
reg         [9:0]                                           i_key_1_r4;
reg         [9:0]                                           i_key_1_r5;

reg         [0:0]                                           i_addr_0_v_r0;
reg         [0:0]                                           i_addr_0_v_r1;
reg         [0:0]                                           i_addr_0_v_r2;
reg         [0:0]                                           i_addr_0_v_r3;
reg         [0:0]                                           i_addr_0_v_r4;
reg         [0:0]                                           i_addr_0_v_r5;

reg         [1:0]                                           time_step_r0;
reg         [1:0]                                           time_step_r1;
reg         [1:0]                                           time_step_r2;
reg         [1:0]                                           time_step_r3;
reg         [1:0]                                           time_step_r4;
reg         [1:0]                                           time_step_r5;


always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        i_addr_0_r0                                 <=      'd0;
        i_addr_0_r1                                 <=      'd0;
        i_addr_0_r2                                 <=      'd0;
        i_addr_0_r3                                 <=      'd0;
        i_addr_0_r4                                 <=      'd0;
        i_addr_0_r5                                 <=      'd0;
        i_addr_1_r0                                 <=      'd0;
        i_addr_1_r1                                 <=      'd0;
        i_addr_1_r2                                 <=      'd0;
        i_addr_1_r3                                 <=      'd0;
        i_addr_1_r4                                 <=      'd0;
        i_addr_1_r5                                 <=      'd0;
        i_key_0_r0                                  <=      'd0;
        i_key_0_r1                                  <=      'd0;
        i_key_0_r2                                  <=      'd0;
        i_key_0_r3                                  <=      'd0;
        i_key_0_r4                                  <=      'd0;
        i_key_0_r5                                  <=      'd0;
        i_key_1_r0                                  <=      'd0;
        i_key_1_r1                                  <=      'd0;
        i_key_1_r2                                  <=      'd0;
        i_key_1_r3                                  <=      'd0;
        i_key_1_r4                                  <=      'd0;
        i_key_1_r5                                  <=      'd0;
        i_addr_0_v_r0                               <=      'd0;
        i_addr_0_v_r1                               <=      'd0;
        i_addr_0_v_r2                               <=      'd0;
        i_addr_0_v_r3                               <=      'd0;
        i_addr_0_v_r4                               <=      'd0;
        i_addr_0_v_r5                               <=      'd0;
        time_step_r0                                <=      'd0;
        time_step_r1                                <=      'd0;
        time_step_r2                                <=      'd0;
        time_step_r3                                <=      'd0;
        time_step_r4                                <=      'd0;
        time_step_r5                                <=      'd0;
    end
    else begin
        i_addr_0_r0                                 <=      i_addr_0;
        i_addr_0_r1                                 <=      i_addr_0_r0;
        i_addr_0_r2                                 <=      i_addr_0_r1;
        i_addr_0_r3                                 <=      i_addr_0_r2;
        i_addr_0_r4                                 <=      i_addr_0_r3;
        i_addr_0_r5                                 <=      i_addr_0_r4;
        i_addr_1_r0                                 <=      i_addr_1;
        i_addr_1_r1                                 <=      i_addr_1_r0;
        i_addr_1_r2                                 <=      i_addr_1_r1;
        i_addr_1_r3                                 <=      i_addr_1_r2;
        i_addr_1_r4                                 <=      i_addr_1_r3;
        i_addr_1_r5                                 <=      i_addr_1_r4;
        i_addr_0_v_r0                               <=      i_addr_0_v;
        i_addr_0_v_r1                               <=      i_addr_0_v_r0;
        i_addr_0_v_r2                               <=      i_addr_0_v_r1;
        i_addr_0_v_r3                               <=      i_addr_0_v_r2;
        i_addr_0_v_r4                               <=      i_addr_0_v_r3;
        i_addr_0_v_r5                               <=      i_addr_0_v_r4;
        time_step_r0                                <=      i_time_step;
        time_step_r1                                <=      time_step_r0;
        time_step_r2                                <=      time_step_r1;
        time_step_r3                                <=      time_step_r2;
        time_step_r4                                <=      time_step_r3;
        time_step_r5                                <=      time_step_r4;
    end
end

endmodule