/* 

The top module of PBSketch

*/

module PBSketch (
    input                                                   clk,
    input                                                   rst_n,

    (* dont_touch = "true" *) input   [31:0]                                          i_element,
    (* dont_touch = "true" *) input                                                   i_element_v,

    (* dont_touch = "true" *) output  reg [1:0]                                       o_burst_time,
    (* dont_touch = "true" *) output  reg [9:0]                                       o_addr,
    (* dont_touch = "true" *) output  reg [2:0]                                       o_key,
    (* dont_touch = "true" *) output  reg [4:0]                                       o_freq,
    (* dont_touch = "true" *) output  reg                                             burst_valid
);




// timer imp
reg     [9:0]                                               clk_cnter;
always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        clk_cnter                                   <=      10'b0;     
    end
    else begin
        if (clk) begin
            clk_cnter                               <=      clk_cnter + 1'b1;
        end
    end
end


reg     [1:0]                                               time_step;
always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        time_step                                   <=      2'b0;    
    end
    else begin
        if(clk_cnter == 10'b11_1111_1111) begin
            time_step                               <=      time_step + 1'b1;
        end
    end
end







// hash imp

wire    [31:0]                                              crc_out_0_w;
wire    [31:0]                                              crc_out_1_w;

CRC32_D104  crc_0 (
    .d                                          (i_element),
    .crc_last                                   (32'h0000_ffff),
    .crc_out                                    (crc_out_0_w)
);

CRC32_D104  crc_1 (
    .d                                          (i_element),
    .crc_last                                   (32'hffff_0000),
    .crc_out                                    (crc_out_1_w)
);


reg     [9:0]                                               addr_0;
reg     [2:0]                                               key_0;
reg                                                         hash_0_v;

reg     [9:0]                                               addr_1;
reg     [2:0]                                               key_1;
reg                                                         hash_1_v;

always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        addr_0                                      <=      10'b0;
        key_0                                       <=      3'b0;
        hash_0_v                                    <=      1'b0;

        addr_1                                      <=      10'b0;
        key_1                                       <=      3'b0;
        hash_1_v                                    <=      1'b0;
    end
    else begin
        hash_0_v                                    <=      i_element_v;
        hash_1_v                                    <=      i_element_v;
        addr_0                                      <=      crc_out_0_w[9:0];
        key_0                                       <=      crc_out_0_w[12:10];
        addr_1                                      <=      crc_out_1_w[9:0];
        key_1                                       <=      crc_out_1_w[12:10];
    end
end





// insert layer imp
wire    [9:0]                                               cold2hot_addr_0;
wire    [2:0]                                               cold2hot_key_0;
wire    [0:0]                                               cold2hot_hot_0_v;
wire    [4:0]                                               cold2hot_freq_0;

wire    [9:0]                                               cold2hot_addr_1;
wire    [2:0]                                               cold2hot_key_1;
wire    [0:0]                                               cold2hot_hot_1_v;
wire    [4:0]                                               cold2hot_freq_1;

wire    [1:0]                                               cold2hot_ts;

(* dont_touch = "true" *) Insert_Layer insert_layer (
    .clk                                            (clk),
    .rst_n                                          (rst_n),
    .i_time_step                                    (time_step),
    .i_addr_0                                       (addr_0),
    .i_key_0                                        (key_0),
    .i_addr_0_v                                     (hash_0_v),
    .i_addr_1                                       (addr_1),
    .i_key_1                                        (key_1),
    .i_addr_1_v                                     (hash_1_v),
    .o_addr_0                                       (cold2hot_addr_0),
    .o_key_0                                        (cold2hot_key_0),
    .o_hot_0_v                                      (cold2hot_hot_0_v),
    .o_freq_0                                       (cold2hot_freq_0),
    .o_addr_1                                       (cold2hot_addr_1),
    .o_key_1                                        (cold2hot_key_1),
    .o_hot_1_v                                      (cold2hot_hot_1_v),
    .o_freq_1                                       (cold2hot_freq_1),
    .o_time_step                                    (cold2hot_ts)
);



// hot layer imp
wire    [1:0]                                       o_burst_time_w;
wire    [9:0]                                       o_addr_w;
wire    [2:0]                                       o_key_w;
wire    [4:0]                                       o_freq_w;
wire                                                burst_valid_w;


always @ (posedge clk or negedge rst_n) begin
    if(~rst_n) begin
        o_burst_time                                <=      'd0;
        o_addr                                      <=      'd0;
        o_key                                       <=      'd0;
        o_freq                                      <=      'd0;
        burst_valid                                 <=      'd0;
    end
    else begin
        o_burst_time                                <=      o_burst_time_w;
        o_addr                                      <=      o_addr_w;
        o_key                                       <=      o_key_w;
        o_freq                                      <=      o_freq_w;
        burst_valid                                 <=      burst_valid_w;
    end
end


(* dont_touch = "true" *) Hot_Layer   hot_layer (
    .clk                                            (clk),
    .rst_n                                          (rst_n),
    .i_time_step                                    (cold2hot_ts),

    .i_addr_0                                       (cold2hot_addr_0),
    .i_key_0                                        (cold2hot_key_0),
    .i_freq_0                                       (cold2hot_freq_0),
    .i_hot_0                                        (cold2hot_hot_0_v),

    .i_addr_1                                       (cold2hot_addr_1),
    .i_key_1                                        (cold2hot_key_1),
    .i_freq_1                                       (cold2hot_freq_1),
    .i_hot_1                                        (cold2hot_hot_1_v),

    .o_burst_time                                   (o_burst_time_w),
    .o_addr                                         (o_addr_w),
    .o_key                                          (o_key_w),
    .o_freq                                         (o_freq_w),
    .burst_valid                                    (burst_valid_w)
);


endmodule