

#ifndef _PBSKETCH_H
#define _PBSKETCH_H

#include "PBSketch/PartTwo/PartTwo.h"

#include "PartOne/PartOne.h"
#include "../common/peridoc.hpp"
#include "../common/burstSetter.h"
#include "Baseline/burst/BurstSketchSetter.h"
#include "common/periodicSetter.h"
#include "PartOne/PartOneSetter.h"


template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
class PBSketch {
public:
    void insert(ID_TYPE _id, uint64_t _timestamp);
    void windowTransition();
    PTwoItemPairHashMap Report(uint64_t _hit);
    std::vector<PBflow> ReportTop();
    uint32_t setWindowsSize(uint32_t _size);
    uint64_t setWindowsTime(uint32_t _time);
    void setCountBaseWindows(uint32_t _size, int _winColdThres, int _lambda, uint32_t _burstThreshold);
    void setTimeBaseWindows(uint32_t _time, int _winColdThres, int _lambda, uint32_t _burstThreshold);
    void setBurst(BurstSetter _burstSetter);
    void setPeriodicPart(double _delta, int _topK);
    void setPeriodicPart(PeriodicSetter _periodicPartSetter);
    void addHashSeed(int i){
        pPartOne_->HashSeed_ += i;
        partTwo_.HASH_SEED += i;
    }
    PBSketch(BurstSetter _burstSetter, PartOneSetter _partOneSetter, PeriodicSetter _periodicPartSetter, uint32_t _partTwoMemory);
    ~PBSketch();

    std::vector<UpDownBurst<ID_TYPE>> burstResult;
public:
    bool countBased_;
    uint32_t window_size;
    uint64_t window_time;
    int win_cold_thres;
    int lambda;
    uint32_t burstThreshold_;

    double delta_;
    int topK_;

    TIME_TYPE maxTimestamp_;


public:
    uint64_t start_time{};
    uint64_t last_timestamp = 0;
    uint32_t win_cnt = 0;

    PartOne<ID_TYPE, COUNT_TYPE, uint32_t , uint16_t , uint16_t> *pPartOne_ = nullptr;

    PartTwo<CELL_NUM> partTwo_;

public:
    std::vector<UpDownBurst<ID_TYPE>> burstsLastWindow_;

};

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::PBSketch(BurstSetter _burstSetter,
                                                 PartOneSetter _partOneSetter,
                                                 PeriodicSetter _periodicPartSetter, uint32_t _partTwoMemory):
        partTwo_(_periodicPartSetter, _partTwoMemory){
    setBurst(_burstSetter);
    setPeriodicPart(_periodicPartSetter);
    if (!countBased_) {
        last_timestamp = start_time;
    }
    else {
        last_timestamp = 0;
    }
    maxTimestamp_ = _partOneSetter.maxTimestamp_;
    pPartOne_ = new PartOne<ID_TYPE, COUNT_TYPE, uint32_t , uint16_t, uint16_t>(_partOneSetter.memory_, _partOneSetter.levelAmount_, _partOneSetter.maxTimestamp_, _partOneSetter.periodThreshold_, _partOneSetter.upcallRate_, _burstSetter.lambda_, _burstSetter.burstThreshold_, _burstSetter.winColdThres_);


}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setPeriodicPart(PeriodicSetter _periodicPartSetter) {
    setPeriodicPart( _periodicPartSetter.delta_, _periodicPartSetter.topK_);
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void
PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setPeriodicPart(double _delta, int _topK) {
    delta_ = _delta;
    topK_ = _topK;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setBurst(BurstSetter _burstSetter) {
    if(_burstSetter.countBased_){
        setCountBaseWindows(_burstSetter.windowSize_, _burstSetter.winColdThres_, _burstSetter.lambda_,_burstSetter.burstThreshold_);
    }else{
        setTimeBaseWindows(_burstSetter.windowTime_, _burstSetter.winColdThres_, _burstSetter.lambda_,_burstSetter.burstThreshold_);
    }
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setTimeBaseWindows(uint32_t _time, int _winColdThres,
                                                                int _lambda,
                                                                uint32_t _burstThreshold) {
    setWindowsTime(_time);
    win_cold_thres = _winColdThres;
    lambda = _lambda;
    burstThreshold_ = _burstThreshold;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void
PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setCountBaseWindows(uint32_t _size, int _winColdThres,
                                                            int _lambda,
                                                            uint32_t _burstThreshold) {
    setWindowsSize(_size);
    win_cold_thres = _winColdThres;
    lambda = _lambda;
    burstThreshold_ = _burstThreshold;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
uint64_t PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setWindowsTime(uint32_t _time) {
    countBased_ = false;
    window_time = _time;
    return _time;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
uint32_t PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::setWindowsSize(uint32_t _size) {
    countBased_ = true;
    window_size = _size;
    return _size;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::windowTransition(){

    pPartOne_->result.clear();
    pPartOne_->pResult.clear();
    TIME_TYPE compressWinCnt = win_cnt++ % (maxTimestamp_);
    pPartOne_->windowsProcess(compressWinCnt);

    //rate limiting use
    burstsLastWindow_.clear();
    burstsLastWindow_.insert(burstsLastWindow_.end(), pPartOne_->result.begin(), pPartOne_->result.end());

    for(int i = 0; i < pPartOne_->pResult.size(); i++){
        partTwo_.insert(pPartOne_->pResult[i]);
    }


}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::~PBSketch() {
    burstResult.clear();

}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
std::vector<PBflow> PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::ReportTop() {
    return partTwo_.reportTop(topK_);
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
void PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::insert(ID_TYPE _id, uint64_t _timestamp) {
    DATA_TYPE count;
    if (countBased_) {
        while (last_timestamp + window_size < _timestamp) {
            last_timestamp += window_size;

            windowTransition();
        }
    }
    else {
        while (last_timestamp + window_time < _timestamp) {
            last_timestamp += window_time;

            windowTransition();

        }
    }

    TIME_TYPE compressWinCnt = win_cnt % (maxTimestamp_);
    pPartOne_->insert(_id, compressWinCnt);
}


template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
PTwoItemPairHashMap PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>::Report(uint64_t _hit) {
    return partTwo_.report(_hit);
}



#endif
