
#ifndef PBSKETCH_PERIOICPART_H
#define PBSKETCH_PERIOICPART_H

#include <queue>
#include <limits>
#include "PTwoBucket.h"
#include "common/periodicSetter.h"
#include "common/peridoc.hpp"
#include "common/hash.h"

template <uint32_t CELL_NUM>
class PartTwo{
private:
    uint32_t m_prime = 0;
    BucketD<CELL_NUM>* D;

    int findEmptyCellIndex(const BucketD<CELL_NUM>& bucket){
        for(uint32_t i = 0; i < CELL_NUM; ++i){
            if(bucket.cells[i].r == 0){
                return i;
            }
        }
        return -1;
    }

    int findMatchingCellIndex(const BucketD<CELL_NUM>& bucket, const PTwoItemPair& temp_pair){
        for(uint32_t i = 0; i < CELL_NUM; ++i){
            if(bucket.cells[i].key == temp_pair.item && bucket.cells[i].v == temp_pair.time){
                return i;
            }
        }
        return -1;
    }

    void handleFullBucket(BucketD<CELL_NUM>& bucket, const PTwoItemPair& temp_pair){
        COUNT_TYPE r_min = std::numeric_limits<COUNT_TYPE>::max();
        uint32_t min_pos = 0;

        for (uint32_t i = 0; i < CELL_NUM; ++i) {
            if (bucket.cells[i].r < r_min) {
                r_min = bucket.cells[i].r;
                min_pos = i;
            }
        }

        auto _x = 2 * r_min - abs(bucket.C_fail);
        if (_x <= 0 || bob::rng() % _x == 0) {
            bucket.cells[min_pos].key = temp_pair.item;
            bucket.cells[min_pos].v = temp_pair.time;

            if (r_min == 0) {
                bucket.cells[min_pos].r = 1;
            } else {
                bucket.cells[min_pos].r = r_min + (bucket.C_fail / r_min);
            }

            bucket.C_fail = 0;
        } else {
            bucket.C_fail += 1;
        }
    }


public:
    std::vector<uint64_t> POneKeys;
    std::vector<uint32_t> POneTimes;
    int POneSize_ = 0;

    double delta_ = 1;
    uint64_t MEMORY;
    int HASH_SEED = 1;

    PartTwo(uint32_t _MEMORY, int _topk, double _delta = 1): delta_(_delta){
        MEMORY = _MEMORY;
        m_prime = _MEMORY  / sizeof(BucketD<CELL_NUM>);
        D = new BucketD<CELL_NUM>[m_prime];
    }
    PartTwo(PeriodicSetter _periodicPartSetter, uint32_t _memory): PartTwo(_memory, _periodicPartSetter.topK_, _periodicPartSetter.delta_){}

    ~PartTwo(){
        delete [] D;
    }

    void insert(const PTwoItemPair& item, int _pos = -1){
        PTwoItemPair temp(item.time / delta_, item.item);
        uint32_t position = bob::periodichash(temp, HASH_SEED) % m_prime;
        BucketD<CELL_NUM>& bucket = D[position];

        int match_index = findMatchingCellIndex(bucket, temp);

        if(match_index != -1){
            bucket.cells[match_index].r += 1;
            return;
        }

        int empty_index = findEmptyCellIndex(bucket);
        if (empty_index != -1) {
            bucket.cells[empty_index].key = temp.item;
            bucket.cells[empty_index].v = temp.time;
            bucket.cells[empty_index].r = 1;
        } else {
            handleFullBucket(bucket, temp);
        }
    }

    PTwoItemPairHashMap report(COUNT_TYPE HIT){
        PTwoItemPairHashMap ret;
        for(uint32_t i = 0; i < m_prime; ++i){
            for(uint32_t j = 0; j < CELL_NUM; ++j){
                if(D[i].cells[j].r > HIT){
                    ret[PTwoItemPair(D[i].cells[j].v, D[i].cells[j].key)] = D[i].cells[j].r;
                }
            }
        }
        return ret;
    }

    std::vector<PBflow> reportTop(int _topK){
        auto result = report(0);
        std::priority_queue<PBflow> rspq;
        for (auto &iter: result) {
            PBflow pBflow;
            pBflow.num_ = iter.second;
            pBflow.peridocItem_.itemKey_ = iter.first.item;
            pBflow.peridocItem_.peridoc_ = iter.first.time;
            rspq.push(pBflow);
        }
        std::vector<PBflow> res;
        for(int i = 0; i < _topK && !rspq.empty(); i++){
            res.push_back(rspq.top());
            rspq.pop();
        }
        return res;
    }
};

#endif