#ifndef _PART_ONE_Opt_H_
#define _PART_ONE_Opt_H_

#include <cstring>
#include <vector>
#include <iostream>
#include <climits>
#include <cstdint>
#include <limits>
#include <algorithm>
#include "../../common/hash.h"
#include "benchmark/utils/Setterbuilder.h"


template<typename ID_TYPE,typename COUNTER_TYPE, typename TIME_TYPE, typename FP_TYPE, typename FP_COUNTER_TYPE>
class PartOneOpt {
public:
    class FPEntry;
    class IDEntry{
    public:
        static const uint32_t size = sizeof(ID_TYPE) + sizeof(COUNTER_TYPE) + sizeof(COUNTER_TYPE) + sizeof(TIME_TYPE) + sizeof(TIME_TYPE) + sizeof(TIME_TYPE);
        IDEntry() : id_(0), count_(0), preCount_(0), timestamp_(std::numeric_limits<TIME_TYPE>::max()), burstedTime_(std::numeric_limits<TIME_TYPE>::max()){}
        IDEntry(const ID_TYPE _id, COUNTER_TYPE _count, COUNTER_TYPE _precount, TIME_TYPE _timestamp)
                : id_(_id), count_(_count), preCount_(_precount), timestamp_(_timestamp){}
        inline bool isEmpty(){return id_ == 0;}
        inline bool equalId(ID_TYPE _id){return id_ == _id;}
        inline bool haveTimestamp(){return timestamp_ != std::numeric_limits<TIME_TYPE>::max();}
        inline void removeTimestamp(){timestamp_ = std::numeric_limits<TIME_TYPE>::max();}
        inline TIME_TYPE subTimestamp(TIME_TYPE _subedTimestamp, TIME_TYPE _subTimestamp){
            if(_subedTimestamp >= _subTimestamp){
                return _subedTimestamp - _subTimestamp;
            }else{
                return std::numeric_limits<TIME_TYPE>::max() - _subTimestamp + _subedTimestamp;
            }
        }
        inline bool insert(ID_TYPE _id, COUNTER_TYPE _count = 1){
            if(isEmpty()){
                replace(_id, _count);
                return true;
            }
            if(equalId(_id)){
                count_ += _count;
                return true;
            }
            return false;
        }
        inline void replace(ID_TYPE _id, COUNTER_TYPE _count){
            id_ = _id;
            count_ = _count;
            preCount_ = 0;
            removeTimestamp();
            burstedTime_ = std::numeric_limits<TIME_TYPE>::max();
        }
        inline void exchange(FPEntry&fpEntry, ID_TYPE _id){
            COUNTER_TYPE count = fpEntry.count_;
            fpEntry.fp_ = fpEntry.idToFp(id_);
            fpEntry.count_ = count_;
            if(count <= 0){
                _id = 0;
            }
            replace(_id, count);
        }

    public:
        ID_TYPE id_;
        COUNTER_TYPE count_;
        COUNTER_TYPE preCount_;
        TIME_TYPE timestamp_;

        TIME_TYPE burstedTime_;

        TIME_TYPE windowTimestamp_;

    };
    class FPEntry{
    public:
        static const uint32_t size = sizeof(FP_TYPE) + sizeof(FP_COUNTER_TYPE);
        static const uint32_t size2 = sizeof(FP_TYPE) + sizeof(FP_COUNTER_TYPE)/2;

        FPEntry() : fp_(0), count_(0){}
        FPEntry(FP_TYPE _fp, FP_COUNTER_TYPE _count)
                : fp_(_fp), count_(_count){}
        inline bool isEmpty(){return fp_ == 0;}
        static inline FP_TYPE idToFp(ID_TYPE _id){
            ID_TYPE hashValue = _id;
            return hashValue >> (sizeof (ID_TYPE) - sizeof(FP_TYPE));
        }
        inline bool equal(ID_TYPE _id){return fp_ == idToFp(_id);}
        inline void replace(FP_TYPE _fp, FP_COUNTER_TYPE _count){
            fp_ = _fp;
            count_ = _count;
        }
        inline void clear(){fp_ = 0;}
        inline bool input(ID_TYPE _id, FP_COUNTER_TYPE _count = 1){
            if(isEmpty()){
                replace(idToFp(_id), _count);
                return true;
            }
            return false;
        }
        inline bool insert(ID_TYPE _id, FP_COUNTER_TYPE _count = 1){

            if(equal(_id)){

                count_ += _count;
                return true;
            }
            return false;
        }
        inline void loss(FP_COUNTER_TYPE _count = 1){
            if(count_ > 0)
                count_-= _count;
            if(count_ <= 0){
                clear();
            }
        }
        bool operator<(const FPEntry &e) const { return count_ > e.count_; }

    public:
        FP_TYPE fp_;
        FP_COUNTER_TYPE count_;
    };
    class Bucket {
    public:
        inline TIME_TYPE subTimestamp(TIME_TYPE _subedTimestamp, TIME_TYPE _subTimestamp){
            if(_subedTimestamp >= _subTimestamp){
                return _subedTimestamp - _subTimestamp;
            }else{
                return std::numeric_limits<TIME_TYPE>::max() - _subTimestamp + _subedTimestamp;
            }
        }
        explicit Bucket(uint32_t _levelAmount):levelAmount_(_levelAmount),size_(_levelAmount/2 * FPEntry::size2 + (_levelAmount+1)/2 * FPEntry::size + IDEntry::size) {
            fpEntries_.resize(levelAmount_);
        }
        void clear(){}

        bool canKicked(COUNTER_TYPE _count, TIME_TYPE _window, int _thres){

            if(_count > idEntry_.count_ && !idEntry_.haveTimestamp()){
                return true;
            }

            return false;
        }
        void upstair(int _index){

            for(int index = _index; index < fpEntries_.size() - 1; index++){

                fpEntries_[index].replace(fpEntries_[index + 1].fp_, fpEntries_[index + 1].count_);

            }


        }
        void downstair(){

            for(int index = fpEntries_.size() - 1; index > 0; index--){
                fpEntries_[index].replace(fpEntries_[index - 1].fp_, fpEntries_[index - 1].count_);
            }

            if(levelAmount_ > 0){
                fpEntries_[0].replace(FPEntry::idToFp(idEntry_.id_), idEntry_.count_);
            }

        }

        void loss(FP_COUNTER_TYPE _count = 1){
            if(levelAmount_ > 0){
                fpEntries_[levelAmount_ - 1].loss(_count);
            }
        }

        bool input(ID_TYPE _id, COUNTER_TYPE _count = 1){
            for(int index = 0; index < fpEntries_.size(); index ++){
                if(fpEntries_[index].input(_id, _count)){
                    return true;
                }
            }
            return false;
        }

        bool insert(ID_TYPE _id, int&_index, TIME_TYPE _window, int _thres, COUNTER_TYPE&_counter, COUNTER_TYPE _count, int _k, uint32_t _burstThreshold, int _winColdThres, PartTwo<SetterBuilder::CellNum>* _pPartPtr){

            if(idEntry_.windowTimestamp_ != _window){
                windowsProcess(idEntry_.windowTimestamp_, _k, _burstThreshold, _winColdThres, _pPartPtr);

                idEntry_.windowTimestamp_ = _window;

            }

            if(!idEntry_.insert(_id, _count)){
                for(int index = 0; index < fpEntries_.size(); index ++){
                    if(fpEntries_[index].insert(_id, _count)){

                        _counter = fpEntries_[index].count_;
                        _index = BucketSort(index, _id, _window, _thres);
                        return true;
                    }
                }
                return false;
            }else{

                _index = -1;
                return true;
            }

        }
        int BucketSort(int _index, ID_TYPE _id, TIME_TYPE _window, int _thres){

            int index;
            for(index = _index; index > 0; index--){
                if(fpEntries_[index].count_ > fpEntries_[index - 1].count_){
                    FP_TYPE fp = fpEntries_[index].fp_;
                    FP_COUNTER_TYPE count = fpEntries_[index].count_;

                    fpEntries_[index].replace(fpEntries_[index - 1].fp_, fpEntries_[index - 1].count_);
                    fpEntries_[index - 1].replace(fp, count);

                }
            }
            if(levelAmount_ > 0 && fpEntries_[0].count_ > idEntry_.count_ && !idEntry_.haveTimestamp() &&
                    (idEntry_.burstedTime_ == std::numeric_limits<TIME_TYPE>::max() || subTimestamp(_window,idEntry_.burstedTime_) > _thres) ){

                idEntry_.exchange(fpEntries_[0], _id);
                return -1;
            }

            return index;

        }
        void windowsProcess(TIME_TYPE _timestamp, int _k, uint32_t _burstThreshold, int _winColdThres, PartTwo<SetterBuilder::CellNum>* _pPartPtr){
            const auto count = idEntry_.count_;
            const auto preCount = idEntry_.preCount_;
            const auto timestamp = idEntry_.timestamp_;
            if(idEntry_.haveTimestamp()) {
                if (subTimestamp(_timestamp, timestamp)  > _winColdThres) {
                    idEntry_.removeTimestamp();
                }
            }
            if(idEntry_.haveTimestamp()) {

                if(count * _k <= preCount){
                //rate limiting use

//                    UpDownBurst<ID_TYPE>burst;
//                    burst.id = idEntry_.id_;
//                    burst.start_window = timestamp;
//                    burst.end_window = _timestamp;
//                    _result.push_back(burst);


                    if(idEntry_.burstedTime_ != std::numeric_limits<TIME_TYPE>::max()){
                        PTwoItemPair pTwoItemPair;
                        pTwoItemPair.item = idEntry_.id_;
                        pTwoItemPair.time = subTimestamp(timestamp, idEntry_.burstedTime_);
                        _pPartPtr->insert(pTwoItemPair);
                    }
                    idEntry_.burstedTime_ = timestamp;
                    idEntry_.removeTimestamp();
                }
                if (count < _burstThreshold) {
                    idEntry_.removeTimestamp();
                }
            }

            if(preCount * _k <= count && count >= _burstThreshold){
                idEntry_.timestamp_ = _timestamp;

            }

            idEntry_.preCount_ = idEntry_.count_;
            idEntry_.count_ = 0;

            for(int index = 0; index < fpEntries_.size(); index++){
                fpEntries_[index].clear();
            }
        }

    public:
        IDEntry idEntry_;
        std::vector<FPEntry> fpEntries_;
        const uint32_t levelAmount_; //if eq 0, fpEntries is empty
        const int size_;

    };



    PartOneOpt(uint32_t _memory, uint32_t _levelAmount, TIME_TYPE _maxTimestamp,uint32_t _periodThreshold, double _upcallRate, double _k, uint32_t _burstThreshold, uint32_t _winColdThres){

        Bucket bucket(_levelAmount);
        const int bucketSize = bucket.size_;
        bucketAmount_ = (_memory * 1024 ) / bucketSize;
        for(int i = 0; i < bucketAmount_; i++){
            buckets_.push_back(Bucket(_levelAmount));
        }


        k_ = _k;
        burstThreshold_ = _burstThreshold;
        winColdThres_ = _winColdThres;
        periodThreshold_ = _periodThreshold;
        upcallRate = _upcallRate;

    }

    void insert(ID_TYPE _id, TIME_TYPE _window, PartTwo<SetterBuilder::CellNum>* _pPartPtr){

        uint32_t hashValue = hash(_id, 1) ;
        uint32_t bucketIndex1 = hashValue  % bucketAmount_;
        uint32_t bucketIndex2 = (hashValue >> 16) % bucketAmount_;
        int index1 = -1;
        int index2 = -1;
        COUNTER_TYPE counter1 = 0;
        COUNTER_TYPE counter2 = 0;
        COUNTER_TYPE count = 1;
        if(buckets_[bucketIndex1].insert(_id, index1, _window, periodThreshold_, counter1, count, k_, burstThreshold_, winColdThres_, _pPartPtr) ||
        buckets_[bucketIndex2].insert(_id, index2, _window, periodThreshold_, counter2, count, k_, burstThreshold_, winColdThres_, _pPartPtr)){
            if(index1 != -1 && counter1 >= burstThreshold_ * upcallRate){
                if(buckets_[bucketIndex2].canKicked(counter1, _window, periodThreshold_) ){
                    buckets_[bucketIndex2].downstair();
                    buckets_[bucketIndex2].idEntry_.replace(_id, counter1);
                    buckets_[bucketIndex1].upstair(index1);
                }

            }
            else if(index2 != -1 && counter2 >= burstThreshold_ * upcallRate){
                if(buckets_[bucketIndex1].canKicked(counter2, _window, periodThreshold_) ){
                    buckets_[bucketIndex1].downstair();
                    buckets_[bucketIndex1].idEntry_.replace(_id, counter2);
                    buckets_[bucketIndex2].upstair(index2);
                }

            }
        }
        else if(buckets_[bucketIndex1].input(_id) || buckets_[bucketIndex2].input(_id)){

        }
        else{
            buckets_[bucketIndex1].loss();
        }

    }

    std::vector<UpDownBurst<ID_TYPE>> query() {
        windowsProcess(winCnt_++);
        return result;
    }

    void clear(){}

    void windowsProcess(uint32_t _timestamp){
        // for(int index = 0; index < buckets_.size(); index++){
//            buckets_[index].windowsProcess(_timestamp, result, pResult, k_, burstThreshold_, winColdThres_);
        // }
    }

    ~PartOneOpt() = default;


    uint64_t lastTimestamp_;
    uint32_t winCnt_{};
    int k_;
    uint32_t burstThreshold_;
    int winColdThres_ ;
    int periodThreshold_;
    double upcallRate;


    uint32_t bucketAmount_;
    std::vector<Bucket> buckets_;

    std::vector<UpDownBurst<ID_TYPE>> result;
    std::vector<PTwoItemPair> pResult;

};

#endif