#include "ParamTest.h"
#include "gtdetector/PBDetector.h"
#include "Baseline/Baseline.h"
#include "benchmark/utils/Setterbuilder.h"
#include "utils/ParamBuilder.h"
#include "utils/ParamAnalyzer.h"


void ParamTest::runRate(std::string _datasetPath, int _runLength) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Param::Rate::ParamExperimentNum;
    const int MemoriesNum = ParamBuilder::Param::Rate::MemoriesNum;

    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[MemoriesNum][ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[MemoriesNum][ExperimentNum];

    auto memories = ParamBuilder::Param::Rate::memories;
    double rate = SetterBuilder::rOne;
    auto rates = ParamBuilder::Param::Rate::rates;


    PeriodicSetter periodicPartSetter = SetterBuilder::getPeriodicSetter();
    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicPartSetter.delta_);

    bool countBased = burstSetter.countBased_;
    int topK = 100;

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {

            std::cout << "memory: " << memories[indexMemory] << "\n";

            PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();

            uint32_t partTwoMemory_ = (int) (memories[indexMemory] * rates[index] * 1000);
            partOneSetter.memory_ = (int) (memories[indexMemory] * (1 - rates[index]));

            PBSketchs[indexMemory][index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                                      partOneSetter,
                                                                                      periodicPartSetter, partTwoMemory_);

            topK = periodicPartSetter.topK_;
        }
    }

    CAIDADataset caidaDataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = caidaDataset.dataset[i];
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, i);
                }
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, tuple.timestamp);
                }
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }


    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
            auto result = PBSketchs[indexMemory][index]->Report(0);
            for (auto &iter: result) {

                PBflow pBflow;
                pBflow.num_ = iter.second;
                pBflow.peridocItem_.itemKey_ = iter.first.item;
                pBflow.peridocItem_.peridoc_ = iter.first.time;

                PBResults[indexMemory][index][pBflow.peridocItem_] = pBflow;
            }
        }
    }



    auto gt = pBDetector.runCaida(&caidaDataset , _runLength);

    ParamAnalyzer paramAnalyzer(MemoriesNum, ExperimentNum);
    for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
        std::cout << memories[indexMemory] << "KB: \n";
        for (int index = 0; index < ExperimentNum; index++) {
            std::cout << "rate: " << rates[index] << "\n";

            auto perform = Comparer::compareTop(PBResults[indexMemory][index], gt, topK);
            std::cout << perform.getString();
            paramAnalyzer.insert(indexMemory, index, perform);

            std::cout << "\n";
            delete PBSketchs[indexMemory][index];

        }
    }


}

void ParamTest::runPThres(std::string _datasetPath, int _runLength) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Param::PThres::ParamExperimentNum;
    const int MemoriesNum = ParamBuilder::Param::PThres::MemoriesNum;

    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[MemoriesNum][ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[MemoriesNum][ExperimentNum];

    auto memories = ParamBuilder::Param::PThres::memories;
    double rate = SetterBuilder::rOne;
    auto params = ParamBuilder::Param::PThres::params;


    PeriodicSetter periodicPartSetter = SetterBuilder::getPeriodicSetter();
    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicPartSetter.delta_);

    bool countBased = burstSetter.countBased_;
    int topK = 100;

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {

            std::cout << "memory: " << memories[indexMemory] << "\n";

            PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();

            partOneSetter.periodThreshold_ = params[index];

            uint32_t partTwoMemory_ = (int) (memories[indexMemory] * rate * 1000);
            partOneSetter.memory_ = (int) (memories[indexMemory] * (1 - rate));

            PBSketchs[indexMemory][index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                                      partOneSetter,
                                                                                      periodicPartSetter, partTwoMemory_);


            topK = periodicPartSetter.topK_;
        }
    }

    CAIDADataset caidaDataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = caidaDataset.dataset[i];
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, i);
                }
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, tuple.timestamp);
                }
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
            auto result = PBSketchs[indexMemory][index]->Report(0);
            for (auto &iter: result) {

                PBflow pBflow;
                pBflow.num_ = iter.second;
                pBflow.peridocItem_.itemKey_ = iter.first.item;
                pBflow.peridocItem_.peridoc_ = iter.first.time;

                PBResults[indexMemory][index][pBflow.peridocItem_] = pBflow;
            }
        }
    }



    auto gt = pBDetector.runCaida(&caidaDataset , _runLength);

    ParamAnalyzer paramAnalyzer(MemoriesNum, ExperimentNum);
    for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
        std::cout << memories[indexMemory] << "KB: \n";
        for (int index = 0; index < ExperimentNum; index++) {
            std::cout << "PThres: " << params[index] << "\n";

            auto perform = Comparer::compareTop(PBResults[indexMemory][index], gt, topK);
            std::cout << perform.getString();
            paramAnalyzer.insert(indexMemory, index, perform);

            std::cout << "\n";
            delete PBSketchs[indexMemory][index];

        }
    }

}

void ParamTest::runCompressRate(std::string _datasetPath, int _runLength) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Param::CompressRate::ParamExperimentNum;
    const int MemoriesNum = ParamBuilder::Param::CompressRate::MemoriesNum;

    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[MemoriesNum][ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[MemoriesNum][ExperimentNum];

    auto memories = ParamBuilder::Param::CompressRate::memories;
    double rate = SetterBuilder::rOne;
    auto params = ParamBuilder::Param::CompressRate::rates;


    PeriodicSetter periodicPartSetter = SetterBuilder::getPeriodicSetter();
    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicPartSetter.delta_);

    bool countBased = burstSetter.countBased_;
    int topK = 100;

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {

            std::cout << "memory: " << memories[indexMemory] << "\n";

            PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();

            partOneSetter.maxTimestamp_ = (std::numeric_limits<uint32_t>::max() >> (int)((1 - params[index]) * (sizeof(uint32_t) * 8) ) );

            uint32_t partTwoMemory_ = (int) (memories[indexMemory] * rate * 1000);
            partOneSetter.memory_ = (int) (memories[indexMemory] * (1 - rate));
            PBSketchs[indexMemory][index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                                      partOneSetter,
                                                                                      periodicPartSetter, partTwoMemory_);


            topK = periodicPartSetter.topK_;
        }
    }

    CAIDADataset caidaDataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = caidaDataset.dataset[i];
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, i);
                }
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, tuple.timestamp);
                }
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
            auto result = PBSketchs[indexMemory][index]->Report(0);
            for (auto &iter: result) {

                PBflow pBflow;
                pBflow.num_ = iter.second;
                pBflow.peridocItem_.itemKey_ = iter.first.item;
                pBflow.peridocItem_.peridoc_ = iter.first.time;

                PBResults[indexMemory][index][pBflow.peridocItem_] = pBflow;
            }
        }
    }



    auto gt = pBDetector.runCaida(&caidaDataset , _runLength);

    ParamAnalyzer paramAnalyzer(MemoriesNum, ExperimentNum);
    for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
        std::cout << memories[indexMemory] << "KB: \n";
        for (int index = 0; index < ExperimentNum; index++) {
            std::cout << "CompressRate: " << params[index] << "\n";

            auto perform = Comparer::compareTop(PBResults[indexMemory][index], gt, topK);
            std::cout << perform.getString();
            paramAnalyzer.insert(indexMemory, index, perform);

            std::cout << "\n";
            delete PBSketchs[indexMemory][index];

        }
    }

}

void ParamTest::runHRate(std::string _datasetPath, int _runLength) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Param::HRate::ParamExperimentNum;
    const int MemoriesNum = ParamBuilder::Param::HRate::MemoriesNum;

    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[MemoriesNum][ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[MemoriesNum][ExperimentNum];

    auto memories = ParamBuilder::Param::HRate::memories;
    double rate = SetterBuilder::rOne;
    auto params = ParamBuilder::Param::HRate::hRates;

    PeriodicSetter periodicPartSetter = SetterBuilder::getPeriodicSetter();
    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicPartSetter.delta_);

    bool countBased = burstSetter.countBased_;
    int topK = 100;

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {

            std::cout << "memory: " << memories[indexMemory] << "\n";

            PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();

            partOneSetter.upcallRate_ = params[index];

            uint32_t partTwoMemory_ = (int) (memories[indexMemory] * rate * 1000);

            partOneSetter.memory_ = (int) (memories[indexMemory] * (1 - rate));
            PBSketchs[indexMemory][index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                                      partOneSetter,
                                                                                      periodicPartSetter, partTwoMemory_);


            topK = periodicPartSetter.topK_;
        }
    }

    CAIDADataset caidaDataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = caidaDataset.dataset[i];
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, i);
                }
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
                    PBSketchs[indexMemory][index]->insert(tuple.id, tuple.timestamp);
                }
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }

    for(int index = 0 ;index < ExperimentNum; index++) {
        for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
            auto result = PBSketchs[indexMemory][index]->Report(0);
            for (auto &iter: result) {

                PBflow pBflow;
                pBflow.num_ = iter.second;
                pBflow.peridocItem_.itemKey_ = iter.first.item;
                pBflow.peridocItem_.peridoc_ = iter.first.time;

                PBResults[indexMemory][index][pBflow.peridocItem_] = pBflow;
            }
        }
    }



    auto gt = pBDetector.runCaida(&caidaDataset , _runLength);

    ParamAnalyzer paramAnalyzer(MemoriesNum, ExperimentNum);
    for(int indexMemory = 0; indexMemory < MemoriesNum; ++indexMemory) {
        std::cout << memories[indexMemory] << "KB: \n";
        for (int index = 0; index < ExperimentNum; index++) {
            std::cout << "Hrate: " << params[index] << "\n";

            auto perform = Comparer::compareTop(PBResults[indexMemory][index], gt, topK);
            std::cout << perform.getString();
            paramAnalyzer.insert(indexMemory, index, perform);

            std::cout << "\n";
            delete PBSketchs[indexMemory][index];

        }
    }

}

