

#include "ThroughputTest.h"

#include <fstream>


#include "gtdetector/PBDetector.h"
#include "benchmark/utils/Comparer.h"
#include "benchmark/utils/Setterbuilder.h"
#include "utils/ParamBuilder.h"
#include "utils/ParamAnalyzer.h"

void ThroughputTest::run(std::string _datasetPath, int _runLength) {
    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Throughput::CAIDA::ExperimentNum;
    PBSketch<uint64_t, uint32_t, CellNum>*PBSketches[ExperimentNum];
    Baseline<uint64_t, uint32_t, HashNum, CellNum>*Baselines[ExperimentNum];

    auto memories = ParamBuilder::Throughput::CAIDA::memories;
    double rate = SetterBuilder::rOne;
    double baseLineMemoryRate = SetterBuilder::BaselineMemoryRate;

    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    bool countBased = burstSetter.countBased_;
    PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();

    for(int index = 0 ;index < ExperimentNum; index++) {

        BurstSketchSetter burstSketchSetter = SetterBuilder::getBurstSketchSetter();
        PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
        uint32_t partTwoMemory_ = (int)( memories[index] * rate * 1000 );
        uint32_t periodicSketchMemory_ = (int)( memories[index] * baseLineMemoryRate * 1000 );
        double periodicSketchMemoryRate = SetterBuilder::PeriodicSketchMemoryRate;

        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - rate) );
        partOneSetter.memory_ = (int)( memories[index] * (1 - rate) );

        PBSketches[index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                      partOneSetter,
                                                                      periodicSetter, partTwoMemory_);

        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - baseLineMemoryRate) );
        Baselines[index] = new Baseline<uint64_t, uint32_t, HashNum, CellNum>(burstSetter, burstSketchSetter, periodicSetter,
                                                                              periodicSketchMemory_,
                                                                              periodicSketchMemoryRate);

    }
    CAIDADataset caidaDataset(_datasetPath, _runLength);


    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"PBSketch memory: "<< memories[index] <<"\n";
        auto burst_span = testPBSketch<uint64_t, uint32_t, CellNum>(&caidaDataset, _runLength, PBSketches[index], countBased);
        std::cout << "Throughput(Mips):     " << _runLength / (1000 * 1000 * burst_span.count()) << "\n\n";

    }

    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout << "Baseline memory: " << memories[index] << "\n";
        auto burst_span = testBaseline<uint64_t, uint32_t, HashNum, CellNum>(&caidaDataset, _runLength,
                                                                             Baselines[index], countBased);
        std::cout << "Throughput(Mips):     " << _runLength / (1000 * 1000 * burst_span.count()) << "\n\n";
    }

}

void ThroughputTest::runAblation(std::string _datasetPath, int _runLength) {
    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Throughput::Wave::ExperimentNum;
    PBSketchOpt<uint64_t, uint32_t, CellNum>*PBSketches[ExperimentNum];
    PBSketch<uint64_t, uint32_t, CellNum>*Baselines[ExperimentNum];

    auto memories = ParamBuilder::Throughput::Wave::memories;
    double rate = SetterBuilder::rOne;
    double baseLineMemoryRate = SetterBuilder::BaselineMemoryRate;

    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    bool countBased = burstSetter.countBased_;
    PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();

    for(int index = 0 ;index < ExperimentNum; index++) {

        BurstSketchSetter burstSketchSetter = SetterBuilder::getBurstSketchSetter();
        PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
        uint32_t partTwoMemory_ = (int)( memories[index] * rate * 1000 );

        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - rate) );
        partOneSetter.memory_ = (int)( memories[index] * (1 - rate) );
        PBSketches[index] = new PBSketchOpt<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                         partOneSetter,
                                                                         periodicSetter, partTwoMemory_);
        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - baseLineMemoryRate) );
        Baselines[index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                     partOneSetter,
                                                                     periodicSetter, partTwoMemory_);
    }
    CAIDADataset caidaDataset(_datasetPath, _runLength);

    int span = burstSetter.windowSize_;
//    const int segNum = 300;
    const int segNum = 30;
    int begin = 0;
    int end = span/segNum;

    ParamAnalyzer paramAnalyzer(segNum - 1, 2);
    double params[segNum - 1] = {};


    for(int i = 0; i < segNum - 1; i++) {
        std::cout<<"time:"<<begin<<"\n";
        params[i] = begin;
        double pbOptThp,pbThp;

        for (int index = 0; index < ExperimentNum; index++) {
            auto burst_spans = testPBSketchOptVal<uint64_t, uint32_t, CellNum>(&caidaDataset, _runLength,
                                                                                      PBSketches[index], countBased,
                                                                                      span, begin, end);
            double arr = 0.0;
            for (int i = 0; i < burst_spans.size(); i++) {
                arr += (span/segNum) / (1000 * 1000 * burst_spans[i].count());
            }
            pbOptThp = arr / burst_spans.size();
            std::cout << "PBSketchOpt Throughput(Mips):     " << arr / burst_spans.size() << "\n";

        }
        for (int index = 0; index < ExperimentNum; index++) {
            auto burst_spans = testPBSketchVal<uint64_t, uint32_t, CellNum>(&caidaDataset, _runLength,
                                                                                   Baselines[index], countBased, span,
                                                                                   begin, end);
            double arr = 0.0;
            for (int i = 0; i < burst_spans.size(); i++) {
                arr += (span/segNum) / (1000 * 1000 * burst_spans[i].count());

            }
            pbThp = arr / burst_spans.size();
            std::cout << "PBSketch Throughput(Mips):     " << arr / burst_spans.size() << "\n";

        }
        Performance performance(pbOptThp , 0, 0,0);
        paramAnalyzer.insert(i, 0, performance);
        Performance performance2(pbThp , 0, 0,0);
        paramAnalyzer.insert(i, 1, performance2);

        begin += span/segNum;
        end += span/segNum;
    }

}

void ThroughputTest::runMawi(std::string _datasetPath, int _runLength) {
    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Throughput::Mawi::ExperimentNum;
    PBSketch<uint64_t, uint32_t, CellNum>*PBSketches[ExperimentNum];

    Baseline<uint64_t, uint32_t, HashNum, CellNum>*Baselines[ExperimentNum];


    auto memories = ParamBuilder::Throughput::Mawi::memories;
    double rate = SetterBuilder::rOne;
    double baseLineMemoryRate = SetterBuilder::BaselineMemoryRate;

    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    bool countBased = burstSetter.countBased_;
    PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();

    for(int index = 0 ;index < ExperimentNum; index++) {

        BurstSketchSetter burstSketchSetter = SetterBuilder::getBurstSketchSetter();
        PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
        uint32_t partTwoMemory_ = (int)( memories[index] * rate * 1000 );
        uint32_t periodicSketchMemory_ = (int)( memories[index] * baseLineMemoryRate * 1000 );
        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - rate) );
        double periodicSketchMemoryRate = SetterBuilder::PeriodicSketchMemoryRate;

        PBSketches[index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                      partOneSetter,
                                                                      periodicSetter, partTwoMemory_);

        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - baseLineMemoryRate) );
        Baselines[index] = new Baseline<uint64_t, uint32_t, HashNum, CellNum>(burstSetter, burstSketchSetter, periodicSetter,
                                                                              periodicSketchMemory_, periodicSketchMemoryRate);

    }
    MAWIDataset dataset(_datasetPath, _runLength);

    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"PBSketch memory: "<< memories[index] <<"\n";
        auto burst_span = testPBSketchMawi<uint64_t, uint32_t, CellNum>(&dataset, _runLength, PBSketches[index], countBased);
        std::cout << "Throughput(Mips):     " << _runLength / (1000 * 1000 * burst_span.count()) << "\n";
    }
    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"Baseline memory: "<< memories[index] <<"\n";
        auto burst_span = testBaselineMawi<uint64_t, uint32_t, HashNum, CellNum>(&dataset, _runLength, Baselines[index], countBased);
        std::cout << "Throughput(Mips):     " << _runLength / (1000 * 1000 * burst_span.count()) << "\n";

    }


}


template<typename ID_TYPE, typename DATA_TYPE, uint32_t HASH_NUM, uint32_t CELL_NUM>
std::chrono::duration<double> ThroughputTest::testBaseline(CAIDADataset*_dataset, int _runLength,
                                                           Baseline<ID_TYPE, DATA_TYPE, HASH_NUM, CELL_NUM> *_Baseline,
                                                           bool _countBased) {

    auto burst_start = std::chrono::steady_clock::now();
    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = _dataset->dataset[i];

        if (_countBased) {
            _Baseline->insert(tuple.id, i);
        } else {
            _Baseline->insert(tuple.id, tuple.timestamp);
        }

    }
    auto burst_end = std::chrono::steady_clock::now();
    std::chrono::duration<double> burst_span = std::chrono::duration_cast<std::chrono::duration<double>>(burst_end - burst_start);

    return burst_span;
}
template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
std::chrono::duration<double> ThroughputTest::testPBSketch(CAIDADataset*_dataset, int _runLength,
                                                           PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM> *_PBSketch,
                                                           bool _countBased) {


    auto burst_start = std::chrono::steady_clock::now();
    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = _dataset->dataset[i];

        if (_countBased) {
            _PBSketch->insert(tuple.id, i);
        } else {
            _PBSketch->insert(tuple.id, tuple.timestamp);
        }

    }
    auto burst_end = std::chrono::steady_clock::now();
    std::chrono::duration<double> burst_span = std::chrono::duration_cast<std::chrono::duration<double>>(burst_end - burst_start);


    return burst_span;
}


template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM >
std::vector<std::chrono::duration<double> > ThroughputTest::testPBSketchOptVal(CAIDADataset*_dataset, int _runLength,
                                                                                PBSketchOpt<ID_TYPE, DATA_TYPE, CELL_NUM> *_PBSketch,
                                                                                bool _countBased, int _span, int _begin, int _end) {

    std::vector<std::chrono::time_point<std::chrono::_V2::steady_clock, std::chrono::duration<long long int, std::ratio<1, 1000000000> > > > times;
    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = _dataset->dataset[i];
        if(i % _span == _begin){
            auto time = std::chrono::steady_clock::now();
            times.push_back(time);
        }
        if(i % _span == _end){
            auto time = std::chrono::steady_clock::now();
            times.push_back(time);
        }

        if (_countBased) {
            _PBSketch->insert(tuple.id, i);
        } else {
            _PBSketch->insert(tuple.id, tuple.timestamp);
        }

    }
    std::vector<std::chrono::duration<double> > res;

    for(int i = 1; i < times.size(); i+=2){
        std::chrono::duration<double> burst_span = std::chrono::duration_cast<std::chrono::duration<double>>(times[i] - times[i-1]);
        res.push_back(burst_span);
    }


    return res;
}

template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM >
std::vector<std::chrono::duration<double> > ThroughputTest::testPBSketchVal(CAIDADataset*_dataset, int _runLength,
                                                                             PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM> *_PBSketch,
                                                                             bool _countBased, int _span, int _begin, int _end) {

    std::vector<std::chrono::time_point<std::chrono::_V2::system_clock, std::chrono::duration<long long, std::ratio<1, 1000000000> > > > times;
    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = _dataset->dataset[i];
        if(i % _span == _begin ){
            auto time = std::chrono::high_resolution_clock ::now();
            times.push_back(time);
        }
        if(i % _span == _end){
            auto time = std::chrono::high_resolution_clock ::now();
            times.push_back(time);
        }

        if (_countBased) {
            _PBSketch->insert(tuple.id, i);
        } else {
            _PBSketch->insert(tuple.id, tuple.timestamp);
        }

    }
    std::vector<std::chrono::duration<double> > res;

    for(int i = 1; i < times.size(); i+=2){
        auto burst_span = std::chrono::duration_cast<std::chrono::nanoseconds>(times[i] - times[i-1]);
        res.push_back(burst_span);
    }


    return res;
}
template<typename ID_TYPE, typename DATA_TYPE, uint32_t HASH_NUM, uint32_t CELL_NUM>
std::chrono::duration<double> ThroughputTest::testBaselineMawi(MAWIDataset *dataset, int _runLength,
                                                               Baseline<ID_TYPE, DATA_TYPE, HASH_NUM, CELL_NUM> *_Baseline,
                                                               bool _countBased) {


    auto burst_start = std::chrono::steady_clock::now();
    for (uint32_t i = 0; i < _runLength; ++i) {
        MAWI_Tuple&tuple = dataset->dataset[i];
        uint64_t id = tuple.dstIp;
        id <<= 32;
        id |= tuple.srcIp;

        if (_countBased) {
            _Baseline->insert(id, i);
        } else {
            _Baseline->insert(id, i);
        }

    }
    auto burst_end = std::chrono::steady_clock::now();
    std::chrono::duration<double> burst_span = std::chrono::duration_cast<std::chrono::duration<double>>(burst_end - burst_start);

    return burst_span;
}


template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM >
std::chrono::duration<double> ThroughputTest::testPBSketchMawi(MAWIDataset *dataset, int _runLength,
                                                           PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM> *_PBSketch,
                                                           bool _countBased) {


    auto burst_start = std::chrono::steady_clock::now();
    for (uint32_t i = 0; i < _runLength; ++i) {

        MAWI_Tuple&tuple = dataset->dataset[i];
        uint64_t id = tuple.dstIp;
        id <<= 32;
        id |= tuple.srcIp;
        if (_countBased) {
            _PBSketch->insert(id, i);
        } else {
            _PBSketch->insert(id, i);
        }

    }
    auto burst_end = std::chrono::steady_clock::now();
    std::chrono::duration<double> burst_span = std::chrono::duration_cast<std::chrono::duration<double>>(burst_end - burst_start);


    return burst_span;
}