#ifndef PBSKETCH_THROUGHPUTTEST_H
#define PBSKETCH_THROUGHPUTTEST_H

#include <chrono>

#include "../common/datasetAnalysis/CAIDADataset.h"
#include "../PBSketch/PBSketch.h"
#include "../PBSketchOpt/PBSketchOpt.h"
#include "Baseline/Baseline.h"
#include "../common/datasetAnalysis/MAWIDataset.h"

class ThroughputTest {
public:


    template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
    static std::chrono::duration<double> testPBSketch(CAIDADataset*_dataset, int _runLength,
                                                      PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>* _PBSketch, bool _countBased);

    template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
    static std::vector<std::chrono::duration<double> >  testPBSketchOptVal(CAIDADataset*_dataset, int _runLength,
                                                                            PBSketchOpt<ID_TYPE, DATA_TYPE, CELL_NUM>* _PBSketch, bool _countBased, int _span, int _begin, int _end);
    template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM>
    static std::vector<std::chrono::duration<double> > testPBSketchVal(CAIDADataset*_dataset, int _runLength,
                                                                        PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>* _PBSketch, bool _countBased, int _span, int _begin, int _end);


    template<typename ID_TYPE, typename DATA_TYPE, uint32_t HASH_NUM, uint32_t CELL_NUM>
    static std::chrono::duration<double>testBaseline(CAIDADataset*_dataset, int _runLength,
                                                     Baseline<ID_TYPE, DATA_TYPE, HASH_NUM, CELL_NUM>* _Baseline, bool _countBased);
    template<typename ID_TYPE, typename DATA_TYPE, uint32_t CELL_NUM >
    static std::chrono::duration<double> testPBSketchMawi(MAWIDataset *dataset, int _runLength,
                                                             PBSketch<ID_TYPE, DATA_TYPE, CELL_NUM>* _PBSketch, bool _countBased);

    template<typename ID_TYPE, typename DATA_TYPE, uint32_t HASH_NUM, uint32_t CELL_NUM>
    static std::chrono::duration<double>testBaselineMawi(MAWIDataset *dataset, int _runLength,
                                                         Baseline<ID_TYPE, DATA_TYPE, HASH_NUM, CELL_NUM>* _Baseline, bool _countBased);

    static void run(std::string _datasetPath, int _runLength);
    static void runAblation(std::string _datasetPath, int _runLength);
    static void runMawi(std::string _datasetPath, int _runLength);


};


#endif //PBSKETCH_THROUGHPUTTEST_H
