#ifndef PBSKETCH_PBDETECTOR_H
#define PBSKETCH_PBDETECTOR_H

#include "burstCorrectDetector.h"
#include "periodCorrectDetector.h"

#include "../../common/datasetAnalysis/CAIDADataset.h"
#include "../../common/datasetAnalysis/MAWIDataset.h"

template<typename ID_TYPE>
class PBDetector {
public:
    BurstCorrectDetector<ID_TYPE>* burstCorrectDetectorPtr = nullptr;
    PeriodCorrectDetector* periodCorrectDetectorPtr = nullptr;
    double delta_;
    bool countBased_;

    PBDetector(BurstSetter _burstSetter, double _delta = 1): delta_(_delta){
        burstCorrectDetectorPtr = new BurstCorrectDetector<ID_TYPE>(_burstSetter);
        countBased_ = _burstSetter.countBased_;
    }
    ~PBDetector(){
        delete burstCorrectDetectorPtr;
        if(periodCorrectDetectorPtr != nullptr){
            delete periodCorrectDetectorPtr;
        }
    }

    std::map<PeridocItem, PBflow> runCaida(CAIDADataset*dataset, uint32_t _runLength){

        for (uint32_t i = 0; i < _runLength; ++i) {
            CAIDA_Tuple&tuple = dataset->dataset[i];

            if (countBased_) {
                burstCorrectDetectorPtr->insert(tuple.id, i);
            } else {
                burstCorrectDetectorPtr->insert(tuple.id, tuple.timestamp);
            }

            if(i%40000 == 0){
                std::cout<<"count: "<<i<<"/"<<_runLength<<"\n";
            }
        }

        std::vector<Burst<uint64_t>> ground_truth = burstCorrectDetectorPtr->query();

        periodCorrectDetectorPtr = new PeriodCorrectDetector(ground_truth, delta_);

        return periodCorrectDetectorPtr->run();

    }

    std::map<PeridocItem, PBflow> runMawi(MAWIDataset*dataset, uint32_t _runLength){

        for (uint32_t i = 0; i < _runLength; ++i) {
            MAWI_Tuple&tuple = dataset->dataset[i];
            uint64_t id = tuple.dstIp;
            id <<= 32;
            id |= tuple.srcIp;

            if (countBased_) {
                burstCorrectDetectorPtr->insert(id, i);

            } else {
                burstCorrectDetectorPtr->insert(id, i);
            }

            if(i%40000 == 0){
                std::cout<<"count: "<<i<<"/"<<_runLength<<"\n";
            }
        }

        std::vector<Burst<uint64_t>> ground_truth = burstCorrectDetectorPtr->query();

        periodCorrectDetectorPtr = new PeriodCorrectDetector(ground_truth, delta_);

        return periodCorrectDetectorPtr->run();

    }
};


#endif
