
#include "memorytest.h"
#include "gtdetector/PBDetector.h"
#include "Baseline/Baseline.h"
#include "benchmark/utils/Setterbuilder.h"
#include "utils/ParamBuilder.h"
#include "utils/ParamAnalyzer.h"

void MemoryTest::run(std::string _datasetPath, int _runLength, int _addHashSeed) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Memory::CAIDA::ExperimentNum;
    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[ExperimentNum];
    Baseline<uint64_t, uint32_t, HashNum, CellNum>*Baselines[ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[ExperimentNum];
    std::map<PeridocItem, PBflow> BaselineResults[ExperimentNum];

    auto memories = ParamBuilder::Memory::CAIDA::memories;
    double rate = SetterBuilder::rOne;
    double baseLineMemoryRate = SetterBuilder::BaselineMemoryRate;

    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicSetter.delta_);

    int topK = periodicSetter.topK_;
    bool countBased = burstSetter.countBased_;

    for(int index = 0 ;index < ExperimentNum; index++) {

        std::cout << "memory: " << memories[index] << "\n";

        BurstSketchSetter burstSketchSetter = SetterBuilder::getBurstSketchSetter();
        PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
        PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();
        uint32_t partTwoMemory_ = (int)( memories[index] * rate * 1000 );
        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - rate) );
        partOneSetter.memory_ = (int)( memories[index] * (1 - rate) );
        double periodicSketchMemoryRate = SetterBuilder::PeriodicSketchMemoryRate;

        PBSketchs[index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                     partOneSetter,
                                                                     periodicSetter, partTwoMemory_);
        PBSketchs[index]->addHashSeed(_addHashSeed);

        uint32_t periodicSKetchMemory_ = (int)( memories[index] * baseLineMemoryRate * 1000 );
        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - baseLineMemoryRate) );
        Baselines[index] = new Baseline<uint64_t, uint32_t, HashNum, CellNum>(burstSetter, burstSketchSetter, periodicSetter,
                                                                              periodicSKetchMemory_,
                                                                              periodicSketchMemoryRate);

    }


    CAIDADataset caidaDataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple&tuple = caidaDataset.dataset[i];
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                PBSketchs[index]->insert(tuple.id, i);
                Baselines[index]->insert(tuple.id, i);
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                PBSketchs[index]->insert(tuple.id, tuple.timestamp);
                Baselines[index]->insert(tuple.id, tuple.timestamp);
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }

   for(int index = 0 ;index < ExperimentNum; index++) {
       auto result = PBSketchs[index]->Report(0);
       for (auto &iter: result) {

           PBflow pBflow;
           pBflow.num_ = iter.second;
           pBflow.peridocItem_.itemKey_ = iter.first.item;
           pBflow.peridocItem_.peridoc_ = iter.first.time;

           PBResults[index][pBflow.peridocItem_] = pBflow;
       }

   }
    for(int index = 0 ;index < ExperimentNum; index++) {
        auto result = Baselines[index]->Report(0);
        for (auto &iter: result) {

            PBflow pBflow;
            pBflow.num_ = iter.second;
            pBflow.peridocItem_.itemKey_ = iter.first.item;
            pBflow.peridocItem_.peridoc_ = iter.first.time;

            BaselineResults[index][pBflow.peridocItem_] = pBflow;
        }

    }


    auto gt = pBDetector.runCaida(&caidaDataset , _runLength);

    ParamAnalyzer paramAnalyzer(ExperimentNum, 2);
    std::cout<<"PBSketch: \n";
    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"memory: "<< memories[index] <<"\n";

        auto perform = Comparer::compareTop(PBResults[index], gt, topK);
        std::cout << perform.getString();
        paramAnalyzer.insert(index, 0, perform);

        std::cout<<"\n";
        delete PBSketchs[index];

    }
    std::cout<<"\nBaseline: \n";
    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"memory: "<< memories[index] <<"\n";

        auto perform = Comparer::compareTop(BaselineResults[index], gt, topK);
        std::cout << perform.getString();
        paramAnalyzer.insert(index, 1, perform);

        std::cout<<"\n";
        delete Baselines[index];

    }

}

void MemoryTest::runMawi(std::string _datasetPath, int _runLength) {

    const int CellNum = SetterBuilder::CellNum;

    const int HashNum = 2;

    const int ExperimentNum = ParamBuilder::Memory::Mawi::ExperimentNum;
    PBSketch<uint64_t, uint32_t, CellNum>*PBSketchs[ExperimentNum];
    Baseline<uint64_t, uint32_t, HashNum, CellNum>*Baselines[ExperimentNum];
    std::map<PeridocItem, PBflow> PBResults[ExperimentNum];
    std::map<PeridocItem, PBflow> BaselineResults[ExperimentNum];

    auto memories = ParamBuilder::Memory::Mawi::memories;
    double rate = SetterBuilder::rOne;
    double baseLineMemoryRate = SetterBuilder::BaselineMemoryRate;

    BurstSetter burstSetter = SetterBuilder::getBurstSetter();
    PeriodicSetter periodicSetter = SetterBuilder::getPeriodicSetter();
    PBDetector<uint64_t> pBDetector(burstSetter, periodicSetter.delta_);

    int topK = periodicSetter.topK_;
    bool countBased = burstSetter.countBased_;


    for(int index = 0 ;index < ExperimentNum; index++) {

        std::cout << "memory: " << memories[index] << "\n";

        BurstSketchSetter burstSketchSetter = SetterBuilder::getBurstSketchSetter();

        PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
        uint32_t partTwoMemory_ = (int)( memories[index] * rate * 1000 );
        uint32_t periodicSketchMemory_ = (int)( memories[index] * baseLineMemoryRate * 1000 );
        double periodicSketchMemoryRate = SetterBuilder::PeriodicSketchMemoryRate;

        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - rate) );
        partOneSetter.memory_ = (int)( memories[index] * (1 - rate) );
        PBSketchs[index] = new PBSketch<uint64_t, uint32_t, CellNum>(burstSetter,
                                                                     partOneSetter,
                                                                     periodicSetter, partTwoMemory_);
        burstSketchSetter.burstMem_ = (int)(memories[index] * (1 - baseLineMemoryRate) );
        Baselines[index] = new Baseline<uint64_t, uint32_t, HashNum, CellNum>(burstSetter, burstSketchSetter, periodicSetter,
                                                                              periodicSketchMemory_,
                                                                              periodicSketchMemoryRate);

    }


    MAWIDataset dataset(_datasetPath, _runLength);

    for (uint32_t i = 0; i < _runLength; ++i) {
        MAWI_Tuple&tuple = dataset.dataset[i];
        uint64_t id = tuple.dstIp;
        id <<= 32;
        id |= tuple.srcIp;
        if (countBased) {
            for(int index = 0 ;index < ExperimentNum; index++){
                PBSketchs[index]->insert(id, i);
                Baselines[index]->insert(id, i);
            }

        } else {
            for(int index = 0 ;index < ExperimentNum; index++){
                PBSketchs[index]->insert(tuple.dstIp, i);
                Baselines[index]->insert(tuple.dstIp, i);
            }
        }

        if(i%400000 == 0){
            std::cout<<"SKetch count: "<<i<<"/"<<_runLength<<"\n";
        }
    }

    for(int index = 0 ;index < ExperimentNum; index++) {
        auto result = PBSketchs[index]->Report(0);
        for (auto &iter: result) {

            PBflow pBflow;
            pBflow.num_ = iter.second;
            pBflow.peridocItem_.itemKey_ = iter.first.item;
            pBflow.peridocItem_.peridoc_ = iter.first.time;

            PBResults[index][pBflow.peridocItem_] = pBflow;
        }

    }
    for(int index = 0 ;index < ExperimentNum; index++) {
        auto result = Baselines[index]->Report(0);

        for (auto &iter: result) {

            PBflow pBflow;
            pBflow.num_ = iter.second;
            pBflow.peridocItem_.itemKey_ = iter.first.item;
            pBflow.peridocItem_.peridoc_ = iter.first.time;

            BaselineResults[index][pBflow.peridocItem_] = pBflow;


        }

    }


    auto gt = pBDetector.runMawi(&dataset , _runLength);

    ParamAnalyzer paramAnalyzer(ExperimentNum, 2);
    std::cout<<"PBSketch: \n";
    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"memory: "<< memories[index] <<"\n";

        auto perform = Comparer::compareTop(PBResults[index], gt, topK);
        std::cout << perform.getString();
        paramAnalyzer.insert(index, 0, perform);

        std::cout<<"\n";
        delete PBSketchs[index];

    }
    std::cout<<"\nBaseline: \n";
    for(int index = 0 ;index < ExperimentNum; index++) {
        std::cout<<"memory: "<< memories[index] <<"\n";

        auto perform = Comparer::compareTop(BaselineResults[index], gt, topK);
        std::cout << perform.getString();
        paramAnalyzer.insert(index, 1, perform);

        std::cout<<"\n";
        delete Baselines[index];

    }



}
