

#include "ParamAnalyzer.h"

#include <fstream>

ParamAnalyzer::ParamAnalyzer(int _memoryNum, int _paramNum):MemoryNum_(_memoryNum),ParamNum_(_paramNum) {
    pPerformances_ = new Performance*[MemoryNum_];
    for(int i = 0; i < MemoryNum_ ; ++i){
        pPerformances_[i] = new Performance[ParamNum_];
    }
}

ParamAnalyzer::~ParamAnalyzer() {
    for(int i = 0; i < MemoryNum_ ; ++i){
        delete[] pPerformances_[i];
    }
    delete[] pPerformances_;
}

void ParamAnalyzer::insert(int _memoryIndex, int _paramIndex, Performance _performance) {
    pPerformances_[_memoryIndex][_paramIndex] = _performance;
}

std::vector<int> ParamAnalyzer::NormalFindF1DeltaZero() {
    std::vector<int> res;
    for(int i = 0; i < ParamNum_; ++i){
        double totalDelta = 0.0;
        double frontF1 = 0.0;
        for(int j = 0; j < MemoryNum_; ++j) {
            if(pPerformances_[j][i].getF1() == -1){
                return res;
            }
            if(j != 0){
                totalDelta += pPerformances_[j][i].getF1() - frontF1;
            }
            frontF1 = pPerformances_[j][i].getF1();
        }
        if(totalDelta <= 0.01){
            res.push_back(i);
            break;
        }

    }

    return res;

}

std::vector<int> ParamAnalyzer::NormalFindF1Best() {
    std::vector<int> res;
    double maxF1 = 0.0;
    for(int i = 0; i < ParamNum_; ++i){
        double totalF1 = 0.0;
        for(int j = 0; j < MemoryNum_; ++j) {
            if(pPerformances_[j][i].getF1() == -1){
                return res;
            }
            totalF1 += pPerformances_[j][i].getF1();
        }
        maxF1 = std::max(maxF1,totalF1);
    }

    for(int i = 0; i < ParamNum_; ++i){
        double totalF1 = 0.0;
        for(int j = 0; j < MemoryNum_; ++j) {
            totalF1 += pPerformances_[j][i].getF1();
        }
        if(totalF1 == maxF1){
            res.push_back(i);
        }
    }
    return res;
}

void ParamAnalyzer::toCsv(const double *_memories, const double *_params, const std::string& _title, const std::string& _path) {
    std::string res;
    for(int i = 0; i < 5; ++i){
        res += getCsvTitle(_params, _title);
        res += getCsvValue(_memories, i);
    }

    std::ofstream outFile(_path, std::ios::out);
    outFile << res;
}

std::string ParamAnalyzer::getCsvTitle(const double *_params, const std::string &_title) {
    std::string res = _title;
    for(int i = 0; i < ParamNum_; ++i){
        res += "," + std::to_string(_params[i]);
    }
    res += "\n";
    return res;
}

std::string ParamAnalyzer::getCsvValue(const double *_memories, int flag) {
    std::string res;
    for(int i = 0; i < MemoryNum_; ++i){
        res += std::to_string((int)_memories[i]) + "KB";
        for(int j = 0; j < ParamNum_; ++j){
            switch (flag) {
                case 0 : res += "," + std::to_string(pPerformances_[i][j].pr_);
                    break;
                case 1 : res += "," + std::to_string(pPerformances_[i][j].rc_);
                    break;
                case 2 : res += "," + std::to_string(pPerformances_[i][j].getF1());
                    break;
                case 3 : res += "," + std::to_string(pPerformances_[i][j].aae_);
                    break;
                case 4 : res += "," + std::to_string(pPerformances_[i][j].are_);
                    break;
            }

        }
        res += "\n";
    }
    res += "\n\n";
    return res;
}

