
#ifndef PBSKETCH_PARAMANALYZER_H
#define PBSKETCH_PARAMANALYZER_H

#include "performance.h"

#include <vector>

class ParamAnalyzer {
    const int MemoryNum_;
    const int ParamNum_;

    Performance **pPerformances_;
public:
    ParamAnalyzer(int _memoryNum, int _paramNum);
    ~ParamAnalyzer();

    void insert(int _memoryIndex, int _paramIndex, Performance _performance);

    std::vector<int> NormalFindF1Best();
    std::vector<int> NormalFindF1DeltaZero();

    void toCsv(const double *_memories, const double *_params, const std::string& _title, const std::string& _path);
    std::string getCsvTitle(const double *_params, const std::string& _title);
    std::string getCsvValue(const double *_memories, int flag);
};


#endif //PBSKETCH_PARAMANALYZER_H
