#include "Setterbuilder.h"

BurstSetter SetterBuilder::getBurstSetter() {
    bool countBased = true;
    int windowSize = 30000;
    int winColdThres = 10;
    int lambda = 2;
    int BurstThreshold = 80;

    BurstSetter burstSetter(countBased, windowSize, winColdThres, lambda, BurstThreshold);

    return burstSetter;
}

BurstSetter SetterBuilder::getAppBurstSetter() {
    bool countBased = true;
    int windowSize = 40000;
    int winColdThres = 10;
    int lambda = 2;
    int BurstThreshold = 70;
    BurstSetter burstSetter(countBased, windowSize, winColdThres, lambda, BurstThreshold);

    return burstSetter;
}


BurstSketchSetter SetterBuilder::getBurstSketchSetter() {
    int hashNum = 6;
    int stage2BucketSize = 4;
    int burstMemory = 50;//(KB)
    double stageRatio = 0.4;
    int runningTrackThres = 16;

    BurstSketchSetter burstPartSetter(hashNum, stage2BucketSize, burstMemory, stageRatio, runningTrackThres);
    return burstPartSetter;
}


PeriodicSetter SetterBuilder::getPeriodicSetter() {
    double delta = 2;
    int topK = 20;
    PeriodicSetter periodicPartSetter(delta, topK);
    return periodicPartSetter;
}

PeriodicSetter SetterBuilder::getAppPeriodicSetter() {
    double delta = 2;
    int topK = 100;
    PeriodicSetter periodicPartSetter(delta, topK);
    return periodicPartSetter;
}


PartOneSetter SetterBuilder::getPartOneSetter() {
    int memory_ = 100;
    int level_ = 2;
    uint32_t  periodThreshold_ = 6;
    double upcallRate_ = 0.9;
    uint32_t maxTimestamp_ = 16;

    return {memory_, level_, periodThreshold_, upcallRate_, maxTimestamp_};
}
