#ifndef _CAIDADATASET_H_
#define _CAIDADATASET_H_

#include <cstdint>
#include <string>
#include <fstream>
#include <vector>
#include <set>

struct CAIDA_Tuple {
    uint64_t timestamp;
    uint64_t id;
};

class CAIDADataset {
public:
    CAIDADataset(std::string PATH, uint32_t _len) {

        std::ifstream ofs;
        ofs.open(PATH, std::ios::binary);
        length = _len;
        for(int i = 0;  i < _len; i++){
            CAIDA_Tuple tuple;
            ofs.read((char *) &tuple, sizeof(CAIDA_Tuple));
            dataset.push_back(tuple);
            st.insert(tuple.id);

        }
        ofs.close();

    }

    ~CAIDADataset() {

    }

public:
    std::vector<CAIDA_Tuple> dataset;
    uint64_t length;
    std::set<uint64_t> st;

};

#endif