

#ifndef PBSKETCH_MAWIDATASET_H
#define PBSKETCH_MAWIDATASET_H

#include <cstdint>
#include <string>
#include <fstream>
#include <vector>
#include <iostream>
#include <set>

struct MAWI_Tuple {


    uint32_t srcIp;
    uint16_t srcPort;
    uint32_t dstIp;
    uint16_t dstPort;

    uint8_t protocol;
    static uint16_t swap_uint16(uint16_t val) {
        return (val << 8) | (val >> 8);
    }
};

class MAWIDataset {
public:
    MAWIDataset(std::string PATH, uint32_t _len) {

        std::ifstream ofs;
        ofs.open(PATH, std::ios::binary);
        length = _len;
        for(int i = 0;  i < _len; i++){

            MAWI_Tuple tuple;
            ofs.read((char *)&tuple.srcIp, sizeof(tuple.srcIp));
            ofs.read((char *)&tuple.srcPort, sizeof(tuple.srcPort));
            ofs.read((char *)&tuple.dstIp, sizeof(tuple.dstIp));
            ofs.read((char *)&tuple.dstPort, sizeof(tuple.dstPort));
            ofs.read((char *)&tuple.protocol, sizeof(tuple.protocol));

            uint64_t id = tuple.dstIp;
            id <<= 32;
            id |= tuple.srcIp;
            st.insert(id);


            dataset.push_back(tuple);
        }
        std::cout<<"IP kinds: "<<st.size()<<"\n";
        ofs.close();

    }

    ~MAWIDataset() {

    }

public:
    std::vector<MAWI_Tuple> dataset;
    uint64_t length;
    std::set<uint64_t> st;
};

#endif //PBSKETCH_CAMPUSDATASET_H
