#include"benchmark/memorytest.h"
#include"benchmark/ThroughputTest.h"
#include"benchmark/ParamTest.h"
#include "ratelimiting/Test.h"
#include <getopt.h>

int main(int argc, char *argv[]){
    /*
    Experiment: ./PBSketch [datasetPath] [length] -[parameter]
        m: MAWWI memory test and throughput test
        c: CAIDA memory test and throughput test
        p: Parameter Tuning test
        r: Rate Limit teat-Limit num test
        d: Rate Limit teat-Dynamic Buckets amount test
    */
    std::string datasetPath;
    int runLength;

    datasetPath = argv[1];
    runLength = atoi(argv[2]);
    int option;
    if((option = getopt(argc, argv, "cmtplb")) != -1){
        switch (option) {
            case 'c':
                MemoryTest::run(datasetPath, runLength);
                ThroughputTest::run(datasetPath, runLength);
                break;
            case 'm':
                MemoryTest::runMawi(datasetPath, runLength);
                ThroughputTest::runMawi(datasetPath, runLength);
                break;
            case 'p':
                ParamTest::runRate(datasetPath, runLength);
                ParamTest::runPThres(datasetPath, runLength);
                ParamTest::runHRate(datasetPath, runLength);
                ParamTest::runCompressRate(datasetPath, runLength);
                break;
            case 'l':
                Test::limitNumTestCaida(datasetPath, runLength);
                break;
            case 'b':
                Test::bucketAmountTestCaida(datasetPath, runLength);
                break;


            default:
                std::cout<<"command error!\n";
                break;
        }
    }

    return 0;
}