#include "Counter.h"

Counter::Counter(int _windowSize, int _opNum) : windowSize_(_windowSize), opNUm_(_opNum){}

void Counter::insert(uint64_t _key, uint64_t t) {
    if(counters.find(_key) == counters.end()){
        counters[_key] = 1;
    }else{
        if(counters[_key] < opNUm_){
            counters[_key]++;
        }else{
            rejectNum_++;
        }
    }

    int windowNum = t / windowSize_;
    checker[_key][windowNum % 2].push_back(t);

    if(t % windowSize_ == 0){
        windowOperate(windowNum);
    }
}

void Counter::windowOperate(uint64_t windowNum) {
    counters.clear();

    for(auto iter = checker.begin(); iter != checker.end();){
        if(iter->second[windowNum % 2].empty()){
            iter = checker.erase(iter);
        }else{
            iter++;
        }
    }

    for(auto& iter : checker){
        auto&past = iter.second[windowNum % 2 ^ 1];
        auto&now = iter.second[windowNum % 2];

        for(auto pastIter = past.begin(); pastIter != past.end(); pastIter++){
            int i;
            for(i = 0; i < now.size(); ++i){
                if(now[i] > *pastIter + windowSize_){
                    break;
                }
            }
            int pastResidue = std::distance(pastIter, past.end());
            if(i + pastResidue > opNUm_){
                overflowNum_++;
                break;
            }
        }
        past.clear();
    }
}