#include "Test.h"

#include <string>
#include <fstream>
#include "LeakyBucket.h"
#include "PBSketchLeakyBucket.h"
#include "PBSketchCounter.h"
#include "Counter.h"
#include "../common/datasetAnalysis/CAIDADataset.h"
#include "benchmark/utils/Setterbuilder.h"
#include "../benchmark/utils/ParamAnalyzer.h"

void Test::limitNumTestCaida(std::string _datasetPath, int _runLength) {
    uint64_t mask = 0xFFFFFFFF00000000;
    int memory = 200;
    std::set<uint64_t> ids;
    BurstSetter burstSetter = SetterBuilder::getAppBurstSetter();

    PeriodicSetter periodicSetter= SetterBuilder::getAppPeriodicSetter();
    PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();

    uint32_t partTwoMemory = (int)(SetterBuilder::rOne * memory * 1000);
    partOneSetter.memory_ = (int)( (1.0 - SetterBuilder::rOne) * memory);
    periodicSetter.topK_ = 200;

    const int CellNum = SetterBuilder::CellNum;

    LeakyBucket *leakyBuckets[experimentNum];
    Counter *counters[experimentNum];
    PBSketchCounter<uint64_t, uint64_t, CellNum>  *pBSketchCounters[experimentNum];
    PBSketchLeakyBucket<uint64_t, uint64_t, CellNum>  *pBSketchLeakyBuckets[experimentNum];
    for(int i = 0; i < experimentNum; i++){
        leakyBuckets[i] = new LeakyBucket(burstSetter.windowSize_, opNums[i], leakyBucketSize);
        counters[i] = new Counter (burstSetter.windowSize_, opNums[i]);
        pBSketchCounters[i] = new PBSketchCounter<uint64_t, uint64_t, CellNum> (burstSetter.windowSize_, opNums[i], dynamicBucketSize, new PBSketch<uint64_t, uint64_t, CellNum>(burstSetter, partOneSetter, periodicSetter, partTwoMemory), dynamicBucketNum);
        pBSketchLeakyBuckets[i] = new PBSketchLeakyBucket<uint64_t, uint64_t, CellNum>  (burstSetter.windowSize_,opNums[i],leakyBucketSize,dynamicBucketSize,new PBSketch<uint64_t, uint64_t, CellNum>(burstSetter, partOneSetter, periodicSetter, partTwoMemory), dynamicBucketNum);
    }




    std::ifstream ofs;
    ofs.open(_datasetPath  , std::ios::binary);


    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple tuple;
        ofs.read((char *) &tuple, sizeof(CAIDA_Tuple));

        tuple.id = tuple.id & mask;
        ids.insert(tuple.id);
        for(int experIndex = 0; experIndex < experimentNum; experIndex++){
            counters[experIndex]->insert(tuple.id, i);
            leakyBuckets[experIndex]->insert(tuple.id, i);
            pBSketchCounters[experIndex]->insert(tuple.id, i);
            pBSketchLeakyBuckets[experIndex]->insert(tuple.id, i);
        }

        if(i%40000 == 0) {
            std::cout << "input num: " << std::dec << i << "\n";
        }
    }
    ParamAnalyzer paramAnalyzer(experimentNum, 4);

    for(int experIndex = 0; experIndex < experimentNum; experIndex++){

        std::cout<<"\n limitNum: "<<opNums[experIndex]<<"\n\n";

        std::cout<<"counter: \n";
        std::cout<<"counter reject num: "<<counters[experIndex]->rejectNum_<<"\n";
        std::cout<<"counter memory: "<<ids.size() * ( sizeof(uint64_t) + sizeof(uint32_t) ) / 1000 / 1000 << "MB\n";
        std::cout<<"overflowNum_: "<<counters[experIndex]->overflowNum_<<"\n";
        Performance performance(counters[experIndex]->rejectNum_, counters[experIndex]->overflowNum_, 0,0);
        paramAnalyzer.insert(experIndex, 0, performance);

        std::cout<<"PBSketch counter: \n";
        std::cout<<"counter reject num: "<<pBSketchCounters[experIndex]->rejectNum_<<"\n";
        std::cout<<"counter memory: "<<ids.size() * ( sizeof(uint64_t) + sizeof(uint32_t) ) / 1000 / 1000 << "MB\n";
        std::cout<<"dynamicBucket memory: "<< pBSketchCounters[experIndex]->maxn * sizeof(uint64_t)  * pBSketchCounters[experIndex]->maxBucketSize_ / 1000 / 1000 << "MB\n";
        std::cout<<"PBSketch memory: "<< (double)memory / 1000<<"MB\n";
        std::cout<<"overflowNum_: "<<pBSketchCounters[experIndex]->overflowNum_<<"\n";
        Performance performance2(pBSketchCounters[experIndex]->rejectNum_, pBSketchCounters[experIndex]->overflowNum_, 0,0);
        paramAnalyzer.insert(experIndex, 1, performance2);

        std::cout<<"LeakyBucket: \n";
        std::cout<<"leakyBucket reject num: "<<leakyBuckets[experIndex]->rejectNum_<<"\n";
        std::cout<<"bucket memory: "<< (double)ids.size() * sizeof(uint64_t) * leakyBuckets[experIndex]->maxBucketSize_ / 1000 / 1000 << "MB\n";
        Performance performance3(leakyBuckets[experIndex]->rejectNum_, 0, 0,0);
        paramAnalyzer.insert(experIndex, 2, performance3);

        std::cout<<"PBSketch LeakyBucket: \n";
        std::cout<<"pBSketchLeakyBucket reject num: "<<pBSketchLeakyBuckets[experIndex]->rejectNum_<<"\n";
        std::cout<<"bucket memory: "<< (double)ids.size() * sizeof(uint64_t) * pBSketchLeakyBuckets[experIndex]->maxBucketSize_ / 1000 / 1000 << "MB\n";
        std::cout<<"dy bucket memory: "<< (double)pBSketchLeakyBuckets[experIndex]->maxn * sizeof(uint64_t)  * pBSketchLeakyBuckets[experIndex]->dynamicBucketCapacity_ / 1000 / 1000 << "MB\n";
        std::cout<<"PBSketch memory: "<< (double)memory / 1000<<"MB\n";
        Performance performance4(pBSketchLeakyBuckets[experIndex]->rejectNum_, 0, 0,0);
        paramAnalyzer.insert(experIndex, 3, performance4);
    }
}


void Test::bucketAmountTestCaida(std::string _datasetPath, int _runLength) {
    uint64_t mask = 0xFFFFFFFF00000000;
    int memory = 200;
    std::set<uint64_t> ids;

    BurstSetter burstSetter = SetterBuilder::getAppBurstSetter();

    PartOneSetter partOneSetter = SetterBuilder::getPartOneSetter();
    PeriodicSetter periodicSetter = SetterBuilder::getAppPeriodicSetter();
    uint32_t partTwoMemory = (int)(SetterBuilder::rOne * memory * 1000);

    partOneSetter.memory_ = (int)( (1.0 - SetterBuilder::rOne) * memory);
    periodicSetter.topK_ = 200;

    const int CellNum = SetterBuilder::CellNum;

    PBSketchCounter<uint64_t, uint64_t, CellNum>  *pBSketchCounters[bucketNumExperimentNum];
    PBSketchLeakyBucket<uint64_t, uint64_t, CellNum>  *pBSketchLeakyBuckets[bucketNumExperimentNum];
    for(int i = 0; i < bucketNumExperimentNum; i++){
        pBSketchCounters[i] = new PBSketchCounter<uint64_t, uint64_t, CellNum> (burstSetter.windowSize_, opNum, dynamicBucketSize, new PBSketch<uint64_t, uint64_t, CellNum>(burstSetter, partOneSetter, periodicSetter, partTwoMemory), bucketNums[i]);
        pBSketchLeakyBuckets[i] = new PBSketchLeakyBucket<uint64_t, uint64_t, CellNum>  (burstSetter.windowSize_, opNum, leakyBucketSize, dynamicBucketSize, new PBSketch<uint64_t, uint64_t, CellNum>(burstSetter, partOneSetter, periodicSetter, partTwoMemory), bucketNums[i]);
    }

    std::ifstream ofs;
    ofs.open(_datasetPath  , std::ios::binary);


    for (uint32_t i = 0; i < _runLength; ++i) {
        CAIDA_Tuple tuple;
        ofs.read((char *) &tuple, sizeof(CAIDA_Tuple));

        tuple.id = tuple.id & mask;
        ids.insert(tuple.id);

        for(int experIndex = 0; experIndex < bucketNumExperimentNum; experIndex++){
            pBSketchCounters[experIndex]->insert(tuple.id, i);
            pBSketchLeakyBuckets[experIndex]->insert(tuple.id, i);
        }

        if(i%40000 == 0) {
            std::cout << "input num: " << std::dec << i << "\n";
        }
    }

    ParamAnalyzer paramAnalyzer(bucketNumExperimentNum, 2);


    for(int experIndex = 0; experIndex < bucketNumExperimentNum; experIndex++){
        std::cout<<"\nbucket Amount: "<<bucketNums[experIndex]<<"\n\n";

        std::cout<<"PBSketch counter: \n";
        std::cout<<"counter reject num: "<<pBSketchCounters[experIndex]->rejectNum_<<"\n";
        std::cout<<"counter memory: "<<ids.size() * ( sizeof(uint64_t) + sizeof(uint32_t) ) / 1000 / 1000 << "MB\n";
        std::cout<<"dynamicBucket memory: "<< pBSketchCounters[experIndex]->maxn * sizeof(uint64_t)  * pBSketchCounters[experIndex]->maxBucketSize_ / 1000 / 1000 << "MB\n";
        std::cout<<"PBSketch memory: "<< (double)memory / 1000<<"MB\n";
        std::cout<<"overflowNum_: "<<pBSketchCounters[experIndex]->overflowNum_<<"\n";
        Performance performance2(pBSketchCounters[experIndex]->rejectNum_, pBSketchCounters[experIndex]->overflowNum_, 0,0);
        paramAnalyzer.insert(experIndex, 0, performance2);

        std::cout<<"PBSketch LeakyBucket: \n";
        std::cout<<"pBSketchLeakyBucket reject num: "<<pBSketchLeakyBuckets[experIndex]->rejectNum_<<"\n";
        std::cout<<"bucket memory: "<< (double)ids.size() * sizeof(uint64_t) * pBSketchLeakyBuckets[experIndex]->maxBucketSize_ / 1000 / 1000 << "MB\n";
        std::cout<<"dy bucket memory: "<< (double)pBSketchLeakyBuckets[experIndex]->maxn * sizeof(uint64_t)  * pBSketchLeakyBuckets[experIndex]->dynamicBucketCapacity_ / 1000 / 1000 << "MB\n";
        std::cout<<"PBSketch memory: "<< (double)memory / 1000<<"MB\n";
        Performance performance4(pBSketchLeakyBuckets[experIndex]->rejectNum_, 0, 0,0);
        paramAnalyzer.insert(experIndex, 1, performance4);
    }
}

