PBSketch
============

Repository structure
--------------------
*  `common/`: Contains common modules and classes shared by all algorithms, such as hash function implementations.
*  `Baseline/`: the implementation of baseline.
*  `PBSketch/`: the implementation of PBSketch.
*  `PBSketchOpt/`: the implementation of PBSketch with WSP Opt.
*  `benchmark/`: code of accuracy, speed and parameter tuning experiment.
*  `ratelimiting/`: code of rate limiting experiment.
*  `FPGA/`: code of FPGA implementation

Requirements
-------
- cmake
- g++

How to run
-------

```bash
$ git clone https://github.com/PBSketch/PBSketch.git
$ cd ./PBSketch/
$ cmake .
$ make
$ ./PBSketch [datasetPath] [length] -[parameter] to start experiment
        m: Conducts accuracy and throughput experiments on the MAWWI dataset.
        c: Conducts accuracy and throughput experiments on the CAIDA dataset.
        p: Executes the parameter tuning experiment.
        l: Executes the rate limiting experiment focusing on the limit number.
        d: Executes the rate limiting experiment focusing on the amount of dynamic buckets.
```